//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: ian reinhart geiser <geiseri@yahoo.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef STATIONDATABASE_H
#define STATIONDATABASE_H

#include <qobject.h>
/**
This is the main database for mapping METAR codes to Station names.

@author ian reinhart geiser
*/

class StationInfo;

class StationDatabase : public QObject
{
	Q_OBJECT
public:
    StationDatabase(QObject *parent = 0L, const char *name =0L);

    virtual ~StationDatabase();


    bool loadDatabase();

    QString stationNameFromID(const QString& id);

    QString stationLongitudeFromID( const QString &stationID);

    QString stationLatitudeFromID(const QString &stationID);

    QString stationCountryFromID( const QString &stationID);

private:
    QMap<QString, StationInfo> theDB;

    bool loadStation( const QString & stationID );

};

#endif
