// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELEDITOR_H
#define CHANNELEDITOR_H

#include <klistview.h>

class ChannelStore;
class Channel;
class SourceManager;
class KPopupMenu;

class ChannelListItem : public QObject, public KListViewItem
{
    Q_OBJECT
public:
    ChannelListItem(KListView* parent, Channel* ch, bool);
    virtual ~ChannelListItem();
    
    virtual int compare(QListViewItem *i, int col, bool ascending) const;
    
    QString _num, _name;
    
	virtual int rtti() const;
	Channel *c;
    
public slots:
    void updateFields();
private:
    bool _showSelectedOnly;
};


/**
 * Channeleditor shell for kdetv.
 */
class ChannelEditor : public KListView
{
    Q_OBJECT

public:
    ChannelEditor(QWidget* parent, SourceManager* srcm, const char* name = 0, bool showSelectedOnly = true);
    ~ChannelEditor();

public slots:
    void setChannels( ChannelStore *chans );
    void renameItem( QListViewItem *item, const QString &str, int col );
    void ensureSelected( Channel *ch );
    void reloadChannels();
    void slotSetShowSelectedOnly(bool);

private slots:
    void requestChange( QListViewItem *item );
    void storeCurrentChannel();
    void restoreCurrentChannel();
    void showContextMenu(KListView *l, QListViewItem *i, const QPoint& p);
    void browseItem();
    void editItem();
    void slotPropertiesDlgFinished();

signals:
    void channelModified( Channel *chan );
    void channelSelected( Channel *chan );

protected:
    void createItems();

private:
    ChannelStore *cs;
    SourceManager* _srcm;
    bool _showSelectedOnly;
    int prev;
    KPopupMenu* _pop;
    int _titleId;
    int _hpId;
};

#endif // CHANNELEDITOR_H

