// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef __KDETVOSD_PLUGIN_H
#define __KDETVOSD_PLUGIN_H

#include <qwidget.h>
#include <qstring.h>
#include "kdetvpluginbase.h"

class KdetvOSDPluginPrivate;

/**
 * OSD plugin base class
 */
class KdetvOSDPlugin : public KdetvPluginBase
{
	Q_OBJECT

public:
	KdetvOSDPlugin(Kdetv *ktv, const QString& cfgkey, QWidget *parent = 0, const char* name = 0);
	virtual ~KdetvOSDPlugin();

public slots:
	virtual void displayMisc(const QString& name) = 0;
	virtual void displayChannel(int channel, const QString& name) = 0;
	virtual void displayMuted(bool muted) = 0;
	virtual void displayVolume(int vol) = 0;
	virtual void displayCC(const QString &text) = 0;
	virtual void clear() = 0;

	virtual void colourKeyChanged(int key);

private:
	KdetvOSDPluginPrivate *d;
};

#endif

