// -*- c++ -*-
/***************************************************************************
                           KdetvDScalerFilter.h
                           --------------------
    begin                : Thu Jul 1 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVDSCALERFILTER_H
#define KDETVDSCALERFILTER_H

#include "kdetvimagefilter.h"

/*
 * kdetv to DScaler deinterlacer/filter API wrapper.
 * Look at DScaler to understand this: www.dscaler.org
 * Only relevant parts of DScaler API for plugins ported
 * to kdetv are implemented.
 * Source level compatibility. I don't want WINE in here.
 */

class KdetvDScalerFilter : public KdetvImageFilter
{
public:
    KdetvDScalerFilter(const QString& name);
    virtual ~KdetvDScalerFilter();

    KdetvImage::ImageFormat inputFormats();

    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx);


protected:
    // How much frames for dscaler at max
    static const unsigned int dscalerHistory = 10;

    // PictureFlags is a bitmask!
    typedef enum {
        PICTURE_PROGRESSIVE     = 0,
        PICTURE_INTERLACED_ODD  = 1,
        PICTURE_INTERLACED_EVEN = 2
    } PictureFlags;

    typedef struct {
        Q_UINT8* pData;
        PictureFlags Flags;
    } TPicture;

    typedef void* (MEMCPY_FUNC)(void* pOutput, const void* pInput, size_t nSize);

    typedef struct {
        TPicture** PictureHistory;
        unsigned char *Overlay;
        unsigned int OverlayPitch;
        unsigned int LineLength;
        int FrameWidth;
        int FrameHeight;
        int FieldHeight;
        MEMCPY_FUNC* pMemcpy;
        long InputPitch;
    } TDeinterlaceInfo;

    virtual void filterDScaler_MMX(TDeinterlaceInfo* pInfo) = 0;

    // A filter can reimplement these if it has optimized versions
    virtual void filterDScaler_3DNOW(TDeinterlaceInfo* pInfo);
    virtual void filterDScaler_SSE(TDeinterlaceInfo* pInfo);
    virtual void filterDScaler_SSE2(TDeinterlaceInfo* pInfo);
};

#endif // KDETVDSCALERFILTER_H
