// -*- c++ -*-
/***************************************************************************
                           kdetvformatconversionfilter.h
                           -----------------------------
    begin                : Wed Aug 26 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVFORMATCONVERSIONFILTER_H
#define KDETVFORMATCONVERSIONFILTER_H

#include "kdetvimage.h"

class KdetvFormatConversionFilter
{
public:
    KdetvFormatConversionFilter();
    virtual ~KdetvFormatConversionFilter();

    void setInputFormat(KdetvImage::ImageFormat fmt);
    KdetvImage::ImageFormat inputFormats();

    void setOutputFormat(KdetvImage::ImageFormat fmt);
    KdetvImage::ImageFormat outputFormats();

    KdetvSharedImage* filter(KdetvSharedImage* in, KdetvSharedImage* out);

private:
    KdetvImage::ImageFormat _inputFormat;
    KdetvImage::ImageFormat _outputFormat;
};

#endif // KDETVFORMATCONVERSIONFILTER_H

