// -*- c++ -*-
/***************************************************************************
                           kdetvimagefilter.h
                           ------------------
    begin                : Sat Jun 12 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef KDETVIMAGEFILTER_H
#define KDETVIMAGEFILTER_H

#include <qptrlist.h>
#include "kdetvimage.h"

class KdetvImageFilterContext;

class KdetvImageFilter
{
 public:
    KdetvImageFilter(const QString& name);
    virtual ~KdetvImageFilter();

    /// Filter the image
    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx) = 0;

    /// All possible input formats
    virtual KdetvImage::ImageFormat inputFormats() = 0;

    /// Current input formats
    KdetvImage::ImageFormat inputFormat() { return _inputFormat; };

    /// The possible output format for the currently selected input format
    /// (usually equal, except for format conversion filters)
    virtual KdetvImage::ImageFormat outputFormats();

    /// The curently selected output format
    KdetvImage::ImageFormat outputFormat();

    /// Set the desired input format
    virtual KdetvImage::ImageFormat setInputFormat(KdetvImage::ImageFormat fmt);

    /// Set the desired output format (usually equal to input format,
    /// must match one of the supported output formats
    virtual KdetvImage::ImageFormat setOutputFormat(KdetvImage::ImageFormat fmt);

    /// Check if the filter can operate (valid input and output format set)
    virtual bool isValid();

    /// Filter's name
    const QString& name() const { return _name; };

    /// Supported Framerate
    bool supportsFullFrameRate() { return _fullFrameRate; };

 protected:
    KdetvImage::ImageFormat _inputFormat;
    KdetvImage::ImageFormat _outputFormat;

    QString _name;
    bool _fullFrameRate;
};

// ----------------------------------------------------------------------------

class KdetvFormatConversionFilter;

class KdetvImageFilterChain : public KdetvImageFilter
{
 public:
    KdetvImageFilterChain();
    virtual ~KdetvImageFilterChain();

    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx);

    virtual KdetvImage::ImageFormat inputFormats();

    virtual KdetvImage::ImageFormat outputFormat();
    virtual KdetvImage::ImageFormat outputFormats();

    virtual KdetvImage::ImageFormat setInputFormat(KdetvImage::ImageFormat fmt);
    virtual KdetvImage::ImageFormat setOutputFormat(KdetvImage::ImageFormat fmt);

    virtual void append(KdetvImageFilter* filter);

    virtual bool isValid();

    /// Remove all filters from chain
    virtual void clear();

    /// Filter chain status
    const QString filterChainStatus() const;

protected:
    void setupChain();
    KdetvImage::ImageFormat chooseFormat(KdetvImage::ImageFormat fmts);

    bool _chainOK;
    QPtrList<KdetvImageFilter> _chain;
};

#endif
