// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef VIEWMANAGER_H
#define VIEWMANAGER_H

#include <qobject.h>
#include <qptrlist.h>

#include "cfgdata.h"

class Kdetv;
class ChannelEditor;
class SettingsDialog;
class SettingsDialogPage;
class SettingsDialogPageFactory;
class SourceManager;
class KDialogBase;

#include "pluginfactory.h"

/**
 * Manages the dialogs and other views.
 *
 * @author Richard Moore, rich@kde.org
 */
class ViewManager : public QObject
{
    Q_OBJECT


public:
    ViewManager( Kdetv *ktv, const char *name=0 );
    ~ViewManager();

    void launchWizard( QWidget *parent );
    void launchImportDefault( QWidget *parent );
    void launchControls( QWidget *parent );
    void launchChannelEditor( QWidget *parent );

    KDialogBase* createSettings( QWidget *parent );
    void launchSettings( QWidget *parent );

    ChannelEditor *createChannelEditor( QWidget *parent );
    ConfigData *getConfig();

    void registerPageFactory(SettingsDialogPageFactory* f);
    void unregisterPageFactory(SettingsDialogPageFactory* f);

    void filterChainStatus(QWidget* parent);

public slots:
    void update();


protected slots:
    void setOptions();


signals:
    void showSelectedChanged(bool);
    void setFixedAspectRatio(bool, int);


private:
    void launchDialog(QWidget* parent, QWidget* p, const QString& caption);

    SourceManager* srcm;
    Kdetv *ktv;
    ConfigData *cfg;
    ConfigData oldConfig;
    QPtrList<SettingsDialogPageFactory> _pageFactories;
};

#endif // VIEWMANAGER_H



