/***************************************************************************
                          systray.cpp  -  A system tray icon that
                          is displayed when the VideoDesktop is enabled
                             -------------------
    begin                : Sun Jul 21 2002
    copyright            : (C) 2002 by Kevin Hessels
    email                : khessels@shaw.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kaction.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kstdaction.h>
#include <ksystemtray.h>


#include <qtooltip.h>

#include "actions.h"
#include "libkdetvactions.h"
#include "systray.h"
#include "systray.moc"

SysTray::SysTray(QWidget *parent, const char *name, KPopupMenu *p, LibKdetvActions *a)
    : KSystemTray(parent, name),
      actions(a),
      menu(p)
{
	setPixmap(BarIcon("kdetv"));
	QToolTip::add(this, i18n("kdetv Control"));
	setAcceptDrops(false);
	return;
} // SysTray constructor


SysTray::~SysTray()
{
	return;
} // SysTray Destructor


/***************************************************************************
*
* Protected Functions
*
***************************************************************************/

void SysTray::mouseDoubleClickEvent(QMouseEvent *)
{
	emit doubleClicked();
	return;
} // mouseDoubleClickEvent


void SysTray::mousePressEvent(QMouseEvent *ev)
{
	switch (ev->button()) {
		case RightButton:
			ev->accept();
			if ( menu )
			    menu->popup(ev->globalPos());
			break;
		default:
			ev->ignore();
			emit leftClicked();
			break;
	} // switch
	
	return;
} // mousePressEvent


void SysTray::wheelEvent(QWheelEvent *ev)
{
	ev->accept();

	if (ev->delta() > 0)
		(void) actions->channelUp()->activate();
	else if (ev->delta() < 0)
		(void) actions->channelDown()->activate();

	return;
} // wheelEvent
