/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *               2003 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <qcolor.h>

#include <kdebug.h>
#include <kcmenumngr.h>

#include "kdetv.h"
#include "kdetvview.h"
#include "viewmanager.h"

#include "kdetvwidget.h"
#include "kdetvwidget.moc"


KdetvWidget::KdetvWidget( QWidget *parent, const char *name, int wflags )
    : QHBox( parent, name ? name : "kdetv_widget", wflags ? wflags : WStyle_Customize | WStyle_Tool ),
      ktv(0), screen(0)
{
    setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
    setDriver( new Kdetv( this ) );
}

KdetvWidget::KdetvWidget( Kdetv *ktv, QWidget *parent, const char *name, int wflags )
    : QHBox( parent, name ? name : "kdetv_widget", wflags ? wflags : WStyle_Customize | WStyle_Tool ),
      ktv(0), screen(0)
{
    setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
    setDriver( ktv );
}

KdetvWidget::~KdetvWidget()
{
}

DCOPRef KdetvWidget::driverIface() const
{
    return DCOPRef( ktv );
}

void KdetvWidget::setDriver( Kdetv *drv )
{
    if ( ktv && (ktv->parent() == this) ) {
        delete ktv;
        screen = 0;
    }

    ktv = drv;
    if ( !ktv )
        return;

    screen = drv->createScreen( this );
}

void KdetvWidget::addContextMenu( QPopupMenu *pop )
{
    if ( !pop )
        return;
    if ( !screen )
        return;

    KContextMenuManager::insert( screen, pop );
}
