TEMPLATE = app
DEPENDPATH += i18n src
INCLUDEPATH += . src  /usr/include/X11 /usr/include/X11R6
LIBPATH += /usr/X11/lib /usr/X11R6/lib
LIBS = -lX11 -lXpm -lXmu
TARGET = kdocker
INSTALL_PATH = /usr/local/share/kdocker
DOCS_PATH = $$INSTALL_PATH/docs

# Defines
TRANSLATIONS_PATH = $$INSTALL_PATH/i18n
DEFINES += TRANSLATIONS_PATH='"$$TRANSLATIONS_PATH"'

ICONS_PATH = $$INSTALL_PATH/icons
DEFINES += ICONS_PATH='"$$ICONS_PATH"'

# Installation
icons.path = $$ICONS_PATH
icons.files = icons/kdocker.png icons/question.png

translations.path = $$TRANSLATIONS_PATH
translations.files = i18n/*.qm

docs.path = $$DOCS_PATH
docs.files = README

desktop.path = /usr/share/applications
desktop.files = kdocker.desktop

target.path = /usr/local/bin

INSTALLS += target icons docs translations desktop

# Input
HEADERS += src/customtraylabel.h \
           src/kdocker.h \
           src/qtraylabel.h \
           src/trace.h \
           src/traylabelmgr.h \
           src/util.h
SOURCES += src/customtraylabel.cpp \
           src/kdocker.cpp \
           src/main.cpp \
           src/qtraylabel.cpp \
           src/trace.cpp \
           src/traylabelmgr.cpp \
           src/util.cpp
           
TRANSLATIONS += i18n/kdocker_en.ts i18n/kdocker_es.ts i18n/kdocker_fr.ts \
                i18n/kdocker_cs.ts i18n/kdocker_ru.ts i18n/kdocker_pt_BR.ts \
                i18n/kdocker_de.ts i18n/kdocker_pl.ts i18n/kdocker_id.ts \
                i18n/kdocker_it.ts

# Debugging (Uncomment line below and make clean; make")
# DEFINES += ENABLE_TRACING

# Output
MOC_DIR = tmp
OBJECTS_DIR = tmp
DESTDIR = .

