/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *	
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: kdocker.h,v 1.11 2005/02/09 03:32:26 cs19713 Exp $

#ifndef _KDOCKER_H
#define _KDOCKER_H

#include <qapplication.h>
#include <X11/Xlib.h>

#define KDOCKER_APP_VERSION "1.3"

class TrayLabelMgr;

class KDocker : public QApplication
{
  Q_OBJECT

public:
  KDocker(int& argc, char** argv);

  TrayLabelMgr *trayLabelMgr(void) { return mTrayLabelMgr; }

  void dumpState(const QString &file);
  void printUsage(char optopt = 'h');

protected:
  bool x11EventFilter(XEvent * event);
  void saveState(QSessionManager &sm);

private:
  QString saveSession();
  bool restoreSession();
  void notifyPreviousInstance(Window prevInstance);

  void printVersion();

  Window mSelectionOwner;
  TrayLabelMgr *mTrayLabelMgr;
};

#endif // _KDOCKER_H
