/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#include <KDebug>

#include "buddylist.h"


BuddyList::BuddyList(QObject* parent)
{

	m_parent = parent;
	setupUi(this);
	//	 m_config = config;
	setWindowIcon(KIcon("folder-remote"));
	
	count = 0;
	buddyVector = new QVector<BuddyContent*>;

	kopeteListWidget = 0;
	listWidgets = 0;
	buddyListWidget = new QListWidget();
	
	buddyListWidget->setMouseTracking(true);
	buddyListWidget->setSelectionRectVisible(false);
	buddyListWidget->setAutoFillBackground(false);
	buddyListWidget->setViewMode(QListView::IconMode);
	buddyListWidget->setResizeMode(QListView::Adjust);
	buddyListWidget->setEnabled(true);
	buddyListWidget->setDragEnabled(false);
	

	tabWidget->clear();	
	tabWidget->addTab(buddyListWidget, KIcon("network-workgroup"), i18n("LAN"));
	
	buddyItemOld = 0;
	dbus = 0;
	
	connect(buddyListWidget, SIGNAL(itemEntered(QListWidgetItem*)),this,SLOT(slotItemEntered(QListWidgetItem*)));
//	connect(buddyListWidget, SIGNAL(itemSelectionChanged()),this,SLOT(slotItemSelectionChanged()));

//	checkICQStatus();
	
}


BuddyList::~BuddyList()
{
	kDebug() << "deleting buddylist";

	if (buddyListWidget) {
		kDebug() << "buddyListWidget deleted";
		delete buddyListWidget;
	}

//	if (kopeteListWidget)
//		delete kopeteListWidget;

	if (listWidgets)
		delete listWidgets;

	if (buddyVector)
		delete buddyVector;

	if (dbus)
		delete dbus;

//	if (buddyItemOld)
//		delete buddyItemOld;
}

void BuddyList::initDefaultBuddyList(QString name)
{	
	checkKopeteStatus();	

	buddyListWidget->setEnabled(true);
	connect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupMenu(QListWidgetItem*)));

	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
		for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc) 
			connect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupKopeteMenu(QListWidgetItem*)));
	}
	m_userName = name;
	show();
}


void BuddyList::initSendClipBuddyList(QString clipEntry, QString username)
{
	disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupMenu(QListWidgetItem*)));

	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			disconnect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupKopeteMenu(QListWidgetItem*)));
	}

	buddyListWidget->setEnabled(true);
	m_clipEntry = clipEntry;
	connect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendClip(QListWidgetItem*)));
	m_userName = username;
	show();
}


void BuddyList::initSendFileBuddyList(QString file, QString username)
{
	checkKopeteStatus();	
	disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupMenu(QListWidgetItem*)));
	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			disconnect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupKopeteMenu(QListWidgetItem*)));
	}

	buddyListWidget->setEnabled(true);
	kDebug() << "initSendFileBuddyList";
	m_fileName = file;
	connect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirect(QListWidgetItem*)));

	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			connect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirectKopete(QListWidgetItem*)));
	}



	m_userName = username;
	show();
}



void BuddyList::addService(QMap<QString, QByteArray> info)
{
	count++;

	QString username = info["User Name"];
	QString hostname = info["Machine Name"];
	QString port = info["port"];
	QString llname = info["llname"];
	
	if (!buddyVector->isEmpty())
		for (int i = 0; i < buddyVector->count(); i++) {
			tmpBuddyContent = buddyVector->at(i);
			if (tmpBuddyContent->name == username && tmpBuddyContent->hostname == hostname)
				return;

		}
	newBuddyContent = new BuddyContent(username,hostname,port.toInt(),info["SN"],info["llname"],this);
	buddyVector->push_back(newBuddyContent);

	buddy = new QListWidgetItem(KIcon("user-identity"), QString(username + "@" + hostname),buddyListWidget);
//	buddy = new QListWidgetItem(KIcon("user"), QString(username + "@" + hostname + ":" + port),buddyListWidget);
	buddyListWidget->addItem(buddy);


}

void BuddyList::delService(QString sn)
{

	kDebug() << "Deleting Buddy!";
	if (!buddyVector->isEmpty())
		for (int i = 0; i < buddyVector->count(); i++) {
			tmpBuddyContent = buddyVector->at(i);
	//		kDebug() << "Name:" << tmpBuddyContent->name << " host: " << tmpBuddyContent->hostname;

			if (tmpBuddyContent->SN == sn) {
				kDebug() << "take item at pos: " << i;
				buddyListWidget->takeItem(i);
				buddyVector->remove(i);
			}
		}
}

void BuddyList::addHttpService(QString srv, QString addr)
{
	if (!httpList.contains(srv))
		httpList[srv] = addr;

}

void BuddyList::delHttpService(QString srv)
{
	if (httpList.contains(srv)) {
		httpList.remove(srv);
	}
}

void BuddyList::slotItemEntered(QListWidgetItem* buddyItem)
{
	 if (buddyItemOld != 0) {
	 	 buddyItemOld->setBackground(Qt::white);
	 	 buddyItemOld->setForeground(Qt::black);
	 }
	 buddyItem->setBackground(QColor("aliceblue"));
	 buddyItem->setForeground(Qt::red);
	 buddyItemOld = buddyItem;

}

void BuddyList::slotItemSelectionChanged()
{
	kDebug() << "changed";



}

void BuddyList::slotPopupMenu(QListWidgetItem* buddyItem)
{
	 disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupMenu(QListWidgetItem*)));
         buddyItem->setBackground(QColor("aliceblue"));
         buddyItem->setForeground(Qt::red);

         popupMenu = new QMenu(this);
         popupMenu->setPalette(Qt::white);

         sendFileAction = popupMenu->addAction(KIcon("text-directory"), "Send File...");
         connect(sendFileAction, SIGNAL(triggered(bool)), this, SLOT(slotSendFile(bool)));
/*
         sendDirAction = popupMenu->addAction(KIcon("inode-directory"), "Send Directory...");
         connect(sendDirAction, SIGNAL(triggered(bool)), this, SLOT(slotSendDir(bool)));
*/
	 sendClipMenu = popupMenu->addMenu(KIcon("klipper"),"Send Clipboard");
 	 connect(sendClipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));
	 addClipEntries();
	
	 if (buddyRunsHttp(buddyItem)){
		 visitUrl = popupMenu->addAction(KIcon("network"), "Published Folder");
        	 connect(visitUrl, SIGNAL(triggered(bool)), this, SLOT(slotShowUrl(bool)));
	 }

//	 getClipAction = popupMenu->addAction(KIcon("klipper"), "Get Clipboard");
//       connect(getClipAction, SIGNAL(triggered(bool)), this, SLOT(slotGetClip(bool)));

         popupMenu->exec(QCursor::pos());
//       pictureButton->setMenu(popupMenu);
	 connect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotPopupMenu(QListWidgetItem*)));

	 

}

void BuddyList::slotPopupKopeteMenu(QListWidgetItem* buddyItem)
{

         buddyItem->setBackground(QColor("aliceblue"));
         buddyItem->setForeground(Qt::red);

         popupMenu = new QMenu(this);
         popupMenu->setPalette(Qt::white);

         sendFileAction = popupMenu->addAction(KIcon("text-directory"), "Send File...");
         connect(sendFileAction, SIGNAL(triggered(bool)), this, SLOT(slotSendFile(bool)));
/*
         sendDirAction = popupMenu->addAction(KIcon("inode-directory"), "Send Directory...");
         connect(sendDirAction, SIGNAL(triggered(bool)), this, SLOT(slotSendDir(bool)));
*/
         popupMenu->exec(QCursor::pos());

}

void BuddyList::slotSendFile(bool ok)
{

	 QListWidgetItem* current = buddyListWidget->selectedItems().at(0);
 	 current->setBackground(QColor("aliceblue"));
     	 current->setForeground(Qt::red);

	 int currentIndex = buddyListWidget->row(current);
	 BuddyContent* cBC = buddyVector->at(currentIndex);
	 kDebug() << "current Buddy Content: user " << cBC->name;
	 kDebug() << "current Buddy Content: SN " << cBC->SN;
	
	 QString fileName = KFileDialog::getOpenFileName(KUrl("./"),"*",this, tr("Select File"));
	 if (!fileName.isEmpty()) {
		 sendHandler = new Sender(m_parent,cBC->llname,cBC->hostname,cBC->port,m_userName);
		 sendHandler->initFileSender(fileName,1);
		 connect(sendHandler,SIGNAL(transferFinished()), this, SLOT(slotSendFinished())); 
		 connect(sendHandler,SIGNAL(transferDenied()), this, SLOT(slotSendFinished()));

	//	 connect(sendHandler, SIGNAL(requestFinished(int)), this, SLOT(slotRequestSend(int)));
	//	 connect(sendHandler, SIGNAL(requestFailed(QString)), this, SLOT(slotRequestFailed(QString)));
		 sendHandler->sendFileRequest();
	}

}

void BuddyList::slotSendClip(QListWidgetItem* buddyItem)
{
	 disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendClip(QListWidgetItem*)));

	 buddyItem->setBackground(QColor("aliceblue"));
     	 buddyItem->setForeground(Qt::red);
	 buddyListWidget->setEnabled(false);

	 if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc) {
			(*acc) -> setEnabled(false);
		}
	}

	 int currentIndex = buddyListWidget->row(buddyItem);
	 BuddyContent* cBC = buddyVector->at(currentIndex);

	 sendHandler = new Sender(m_parent,cBC->llname,cBC->hostname,cBC->port,m_userName);
	 sendHandler->initClipSender();
	 sendHandler->sendClipRequest(m_clipEntry);
	
	 connect(sendHandler,SIGNAL(transferFinished()), this, SLOT(slotSendFinished()));
	 connect(sendHandler,SIGNAL(transferDenied()), this, SLOT(slotSendFinished()));

}


void BuddyList::slotSendFileDirect(QListWidgetItem* buddyItem)
{

	 disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirect(QListWidgetItem*)));
	 buddyItem->setBackground(QColor("aliceblue"));
     	 buddyItem->setForeground(Qt::red);
	 buddyListWidget->setEnabled(false);
	 if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			(*acc) ->setEnabled(false);
	}

	 int currentIndex = buddyListWidget->row(buddyItem);
	 BuddyContent* cBC = buddyVector->at(currentIndex);

	 sendHandler = new Sender(m_parent,cBC->llname,cBC->hostname,cBC->port,cBC->name);
	 sendHandler->initFileSender(m_fileName,1);
	 sendHandler->sendFileRequest();
	
	 connect(sendHandler,SIGNAL(transferFinished()), this, SLOT(slotSendFinished())); 
	 connect(sendHandler,SIGNAL(transferDenied()), this, SLOT(slotSendFinished()));

}

void BuddyList::slotSendFileDirectKopete(QListWidgetItem* buddyItem)
{
	 if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			disconnect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirectKopete(QListWidgetItem*)));
	}

	buddyItem->setBackground(QColor("aliceblue"));
        buddyItem->setForeground(Qt::red);
	buddyListWidget->setEnabled(false);
	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			(*acc) ->setEnabled(false);
	}

        QString displayName = buddyItem->text();
	
	dbus = new QDBusConnection("dbus");
        QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
        QString service = "org.kde.kopete";
        QString path = "/Kopete";
        QString method = "sendFile";
        QString service2 = "org.kde.Kopete";

        QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
        interface->call(method,displayName,m_fileName);
	
}



void BuddyList::slotSendDir(bool ok)
{

}


void BuddyList::slotGetClip(bool ok)
{
/*
	QListWidgetItem* current = buddyListWidget->selectedItems().at(0);
	int currentIndex = buddyListWidget->row(current);
        BuddyContent* cBC = buddyVector->at(currentIndex);

	getClipHandler = new RequestClipboard(this,cBC->hostname,cBC->port,cBC->name);
	getClipHandler->sendRequest();
*/

}

void BuddyList::addClipEntries()
{

	sendClipMenu->clear();
	dbus = new QDBusConnection("dbus");
	QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
	QString service = "org.kde.klipper";
	QString path = "/klipper";
	QString method = "getClipboardHistoryMenu";
	QString service2 = "org.kde.klipper.klipper";

	QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
	QDBusReply<QStringList> reply = interface->call(method);
	
//	kDebug() << "klipper reply: " << reply.value();
	QStringList clipList = reply.value();

	for (int i=0; i < clipList.size(); i++){
		if (clipList.at(i).size() >= 30) {
			QString cut = clipList.at(i);
			cut.truncate(30);
			
			clipAction = sendClipMenu->addAction(cut + " ...");
	         } else
			clipAction = sendClipMenu->addAction(clipList.at(i));
		
		clipAction->setToolTip(clipList.at(i));
		
	}



}

void BuddyList::slotSendClipEntry(QAction* action)
{
 	disconnect(sendClipMenu, SIGNAL(triggered(QAction*)), this, SLOT(slotSendClipEntry(QAction*)));
	m_clipEntry = action->toolTip();
	QListWidgetItem* current = buddyListWidget->selectedItems().at(0);
	slotSendClip(current);

}

void BuddyList::slotSendFinished()
{
	disconnect(sendHandler,SIGNAL(transferFinished()), this, SLOT(slotSendFinished()));
	disconnect(sendHandler,SIGNAL(transferDenied()), this, SLOT(slotSendFinished()));
	disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirect(QListWidgetItem*)));
	disconnect(buddyListWidget, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendClip(QListWidgetItem*)));
	if (listWidgets != 0) {
		QList<QListWidget*>::iterator acc;
                for(acc = listWidgets->begin(); acc != listWidgets->end(); ++acc)
			disconnect(*acc, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(slotSendFileDirectKopete(QListWidgetItem*)));
	}

	sendHandler->deleteLater();
	kDebug() << "sendHandler deleted";
	m_clipEntry = "";
	
	close();

}


void BuddyList::checkKopeteStatus()
{
	if (listWidgets) {
		kDebug() << "Anzahl in listWidgets " << listWidgets->count();

		for(int i =1 ; i <= listWidgets->count(); i++) {
			tabWidget->removeTab(1);
		}
		listWidgets->clear();
	} else
		listWidgets = new QList<QListWidget*>;

	dbus = new QDBusConnection("dbus");
        QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
        QString service = "org.kde.kopete";
        QString path = "/Kopete";
        QString methodAccount = "accounts";
	QString isConnected = "isConnected";
        QString service2 = "org.kde.Kopete";

        QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
        QDBusReply<QStringList> reply = interface->call(methodAccount);
	if (reply.isValid()) {	
		QStringList accountList = reply.value();
		QStringList protoList;
		protoList << "ICQ" << "Jabber";
		for (int i = 0; i < accountList.size(); i++)
		{
			foreach(QString proto,protoList) {
				QDBusReply<bool> reply1 = interface->call(isConnected,proto,accountList.at(i));
				if (reply1.value() == true) {
					ID = accountList.at(i);
					kopeteListWidget = new QListWidget();
					listWidgets->append(kopeteListWidget);
					if (proto == "ICQ") 
							tabWidget->addTab(kopeteListWidget, KIcon("licq"), QString(proto));
					else if(proto == "Jabber")
							tabWidget->addTab(kopeteListWidget, KIcon("jabber_protocol"), QString(proto));
					

					fillKopeteTab(proto);
				}
			}
		
			kDebug() << "Kopete Online Account found = "  << ID;
		}
		

	}
}


void BuddyList::fillKopeteTab(QString proto)
{

	
	kopeteListWidget->clear();
	
	dbus = new QDBusConnection("dbus");
        QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
        QString service = "org.kde.kopete";
        QString path = "/Kopete";
        QString contacts = "contacts";
        QString service2 = "org.kde.Kopete";

        QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
        QDBusReply<QStringList> reply = interface->call(contacts);
	
        QStringList contactList = reply.value();

	kopeteListWidget->setMouseTracking(true);
	kopeteListWidget->setSelectionRectVisible(false);
	kopeteListWidget->setAutoFillBackground(false);
	kopeteListWidget->setViewMode(QListView::IconMode);
	kopeteListWidget->setResizeMode(QListView::Adjust);
	kopeteListWidget->setEnabled(true);
	kopeteListWidget->setDragEnabled(false);

	for (int i = 0; i < contactList.size(); i++)
	{
		QStringList contactInfo = contactList.at(i).split(":");
		if (contactInfo.at(0) == proto + "Protocol") {
			QString contactID = contactInfo.at(2);
			QString contactName = getContactName(contactID);
			if (isOnline(contactName)) {
				buddy = new QListWidgetItem(KIcon("user-identity"), QString(contactName),kopeteListWidget);
				kopeteListWidget->addItem(buddy);
			}
		}
	}

	connect(kopeteListWidget, SIGNAL(itemEntered(QListWidgetItem*)),this,SLOT(slotItemEntered(QListWidgetItem*)));
}


QString BuddyList::getContactName(QString id)
{

	dbus = new QDBusConnection("dbus");
        QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
        QString service = "org.kde.kopete";
        QString path = "/Kopete";
        QString method = "getDisplayName";
        QString service2 = "org.kde.Kopete";

        QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
        QDBusReply<QString> reply = interface->call(method,id);
	
        QString name = reply.value();
	
	return name;
}

bool BuddyList::isOnline(QString name)
{

	dbus = new QDBusConnection("dbus");
        QDBusConnection dbusconn = dbus->connectToBus(QDBusConnection::SessionBus, "dbus");
        QString service = "org.kde.kopete";
        QString path = "/Kopete";
        QString method = "isContactOnline";
        QString service2 = "org.kde.Kopete";

        QDBusInterface* interface = new QDBusInterface(service,path,service2,dbusconn);
        QDBusReply<bool> reply = interface->call(method,name);
	
        bool status = reply.value();
	
	return status;
}

void BuddyList::slotShowUrl(bool)
{
	 QListWidgetItem* current = buddyListWidget->selectedItems().at(0);
 	 current->setBackground(QColor("aliceblue"));
     	 current->setForeground(Qt::red);

	 int currentIndex = buddyListWidget->row(current);
	 BuddyContent* cBC = buddyVector->at(currentIndex);

	 KRun::runUrl(KUrl(QString("http://" + cBC->http)), "text/html", 0);
}

bool BuddyList::buddyRunsHttp(QListWidgetItem* buddy)
{
	 int currentIndex = buddyListWidget->row(buddy);
	 BuddyContent* cBC = buddyVector->at(currentIndex);
 	 kDebug() << "llname: " << cBC->SN;
	 QStringList tmpList = httpList.keys();
	 foreach(QString tmp,tmpList) {
		kDebug() << "Http Service iterator: " << tmp;
		 if (cBC->SN.split("@").at(1) == tmp){
			cBC->http = httpList.value(tmp);
			return true;
		}
	 }
	 return false;
}

