#include <qcanvas.h>
#include <qstring.h>
#include <qimage.h>
#include <qtimer.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "misc.h"
#include "pref.h"
#include "main.h"
#include "fishes.h"


fishSprite::fishSprite( QCanvas *canvas, QObject *parent, const char *name )
            : QObject( parent, name )
            , QCanvasSprite( NULL, canvas )
//            , m_fishPixArray( 0 )
{
    // reload the pix fish
    reloadFish();
    setZ( 1 );
    // witch fish pix i'm showing
    if (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::None )
        fish_state = Showing;
    else
    {
        fish_state = Staying;
        posx = kfishPref::prefs()->getPanelWidth()/2;
    }
    fishDirection = Right;
    fishDirAdd = -1;
    animTimer = new QTimer(this, "Timer");
    connect( animTimer, SIGNAL( timeout() ), SLOT( slotAnimTimeout() ));
	
	connect( kfishApp, SIGNAL( signalSettingsChanged() ), SLOT( slotSettingsChanged() ));
	
    if ( kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Timer )
        animTimer -> start( kfishPref::prefs() -> getTimeInAnimation()*1000, TRUE );

    show();
}


fishSprite::~fishSprite()
{
    delete animTimer;
//    delete m_fishPixArray;
}

void fishSprite::advance( int phase )
{
    if ( ( phase == 0 ) &&  (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::None) )// stuff to be done before we move
    {
        switch (fish_state) {
            case Staying :
                {
                    if ( (!animTimer -> isActive()) && (kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Timer) )
                        animTimer -> start( kfishPref::prefs() -> getTimeInAnimation()*1000, TRUE );
                    break;
                }
            case Showing :
                {
                    posx += fishDirAdd;
                    if ( posx == kfishPref::prefs()->getPanelWidth()/2 )
                        fish_state = Staying;
                    break;
                }
            case Hiding :
                {
                    posx += fishDirAdd;
                    if ( (posx < -mid_imagex ) || (posx > kfishPref::prefs()->getPanelWidth()+mid_imagex ) )
                    {
                        fish_state = Hiden;
                        if (fishDirection == Left)
                            { fishDirection = Right; fishDirAdd = -1; }
                        else
                            { fishDirection = Left; fishDirAdd = 1; }
                    }
                    break;
                }
            case Hiden :
                {
                    if (! show_up)
                        break;
                    fish_state = Showing;
                    if (fishDirection == Right)
                        posx = kfishPref::prefs()->getPanelWidth()+mid_imagex;
                    else
                        posx = -mid_imagex;
                    break;
                }
        }
    }
    else
    {
        move ( posx, posy , fishDirection);
    }
    
}

void fishSprite::slotAnimTimeout()
{
    fish_state = Hiding;
    show_up = true;
}

void fishSprite::slotMouseOverWidget()
{
    if (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::Mouse )
        return;

    fish_state = Hiding;
    show_up = false;
}

void fishSprite::slotMouseNotOverWidget()
{
    if (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::Mouse )
        return;
    if ( ( posy < -mid_imagex ) ||  (posx > kfishPref::prefs()->getPanelWidth()+mid_imagex ) )
    {
        fish_state = Showing;
        if (fishDirection == Right)
            posx = kfishPref::prefs()->getPanelWidth()+mid_imagex;
        else
            posx = -mid_imagex;
    }
    show_up = true;
}

void fishSprite::slotResized()
{
//    kdDebug(1210) << "void fishSprite::slotResized()" << endl;
    setAnimated( false );
    reloadFish();

    mid_imagex = image(0)->width()/2;
    mid_imagey = image(0)->height()/2;
    if (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::None)
    {
        fish_state = Showing;
        if (fishDirection == Right)
            posx = kfishPref::prefs()->getPanelWidth()+mid_imagex;
        else
            posx = -mid_imagex;
    }
    else
    {
        fish_state = Staying;
        posx = kfishPref::prefs()->getPanelWidth()/2;
    }
    posy = kfishPref::prefs()->getPanelHeight()/2;
    setAnimated( true );
}

void fishSprite::slotSettingsChanged()
{
    reloadFish();
    
    if ( kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::None )
    {
        if ((!animTimer -> isActive()) && ( kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Timer ) )
        {
            if (fish_state == Staying)
                animTimer -> start( kfishPref::prefs() -> getTimeInAnimation()*1000, TRUE );
        }
        if ( kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Mouse )
        {
            animTimer -> stop();
        }
    }
    else
    {
        fish_state = Staying;
        posx = kfishPref::prefs()->getPanelWidth()/2;
    }
}

void fishSprite::reloadFish()
{
//    QCanvasPixmapArray *oldpics = m_fishPixArray;
    QCanvasPixmapArray *m_fishPixArray = new QCanvasPixmapArray();
    QString f_name = locate("data","kfish/pics/" + kfishPref::prefs()->getFile());
    getKFishAnimation( *m_fishPixArray, f_name, kfishPref::prefs()->getPanelWidth(), kfishPref::prefs()->getPanelHeight());
    setSequence( m_fishPixArray );
//    if (oldpics) delete oldpics;
    for (int i = 0; i < frameCount(); i++)
        image(i)->setOffset( width()/2, height()/2 );    
}
