#ifndef __FISHES_H__
#define __FISHES_H__

#include <qobject.h>
#include <qstring.h>
#include <qcanvas.h>
#include <qstring.h>

class QTimer;

class fishSprite : public QObject, public QCanvasSprite
{
  Q_OBJECT
public:
    fishSprite( QCanvas *, QObject * = 0, const char * = 0 );
    ~fishSprite();

  void advance( int phase );
    
 signals:
  void signalSendDebug( QString );
    
  protected slots:
    void slotAnimTimeout();
    void slotMouseOverWidget();  
    void slotMouseNotOverWidget(); 
    void slotResized();
    void slotSettingsChanged();
    
 private:
    void reloadFish();
    
    enum fishStates { Showing = 0, Staying, Hiding, Hiden };
    enum fishDirections { Right = 0, Left};
    
    int show_up; /* if the mouse is not over the widget, then i can show it */
    int fish_state;
    int posx;
    int posy;
    
    int fishDirection;
    int fishDirAdd;
    
    int mid_imagex;
    int mid_imagey;
    
    QTimer *animTimer;
};


#endif
