#ifndef __BUBBLES_H__
#define __BUBBLES_H__

#include <qcanvas.h>
#include <qobject.h>
#include <qptrlist.h>

class QTimer;

class kfishBubble : public QObject, public QCanvasSprite
{
    Q_OBJECT
public:
    kfishBubble( QCanvas *, QCanvasPixmapArray * );

public slots:
    void slotAdvance(); // QCanvasSprite
    void slotResized(); // if the QCanvas change its size, i recibe a signal

protected:    
    void advance( int phase ); // QCanvasSprite
    
private:
    void init(); // Set the posy and posx

    int posx;
    int posy;
    int subdiv;
};

class kfishBubbleManager : public QObject
{
    Q_OBJECT
public:
	kfishBubbleManager( QCanvas *, QObject * = 0, const char * = 0 );
    ~kfishBubbleManager();
    
signals:
    void signalResized();

public slots:
    void slotChangeNumberOfBubbles( int );
    void slotSettingsChanged();

private:
    bool addBubble();
    bool delBubble();
    
    int m_numOfBubbles;

    QPtrList<kfishBubble> m_listBubble;
    
    QTimer *m_timer;
    QCanvasPixmapArray *m_bubbles;
    QCanvas *m_canvas;
};

#endif
