/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Description : Widget to edit a batch of photos.
 *
 * Copyright 2008 by M. Asselstine
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef BATCHWIDGET_H
#define BATCHWIDGET_H

#include <QList>
#include <QFrame>
#include <QString>
#include <QSqlRecord>
#include <QItemSelection>
#include <QSqlTableModel>
#include <QStringListModel>

class BatchWidget : public QFrame
{
  Q_OBJECT

public:
  BatchWidget(QWidget* parent = 0, Qt::WindowFlags f = 0);
  ~BatchWidget();

  void setModel(QSqlTableModel* model);
  void editRows(QList<int>& rows);

  void setTagsModel(QStringListModel& model);
  void setLicensesModel(QStringListModel& model);
  void setPhotosetsModel(QStringListModel& model);

public slots:
  void on_title_textEdited(const QString& text);
  void on_rotateCW_clicked();
  void on_rotateCCW_clicked();
  void on_desc_textChanged();
  void on_priv_clicked(bool b);
  void on_pub_clicked(bool b);
  void on_family_clicked(bool b);
  void on_friends_clicked(bool b);
  void on_licenses_activated(int index);
  void on_photosets_activated(int index);
  void on_sizes_currentIndexChanged(const QString& text);
  void on_width_valueChanged(int value);
  void on_height_valueChanged(int value);
  void on_add_clicked(bool b);
  void on_remove_clicked(bool b);
  void on_availableTags_editTextChanged(const QString& text);
  void on_availableTags_activated(const QString &text);

  void tagsSelectionChanged(const QItemSelection& selected, const QItemSelection& deselected);

private:
  class PrivateData;
  PrivateData &d;
};

#endif // BATCHWIDGET_H
