/***********************************************************************
**
**   mapcontrolview.h
**
**   This file is part of KFLog.
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**   This file is distributed under the terms of the General Public
**   Licence. See the file COPYING for more information.
**
**   $Id: mapcontrolview.h,v 1.6 2002/01/04 21:09:01 heiner Exp $
**
***********************************************************************/

#ifndef MAPCONTROLVIEW_H
#define MAPCONTROLVIEW_H

#include <qlabel.h>

#include <qlcdnumber.h>
#include <qslider.h>
#include <qwidget.h>

class KFLogApp;

/**
 * Creates widgets for controling the mapview. The class will create
 * the compass-rose, consisting of nine KButtons to move the map,
 * two labels showing the dimension of the current mapview and a slider
 * to set the scale.
 *
 * @author Heiner Lamprecht, Florian Ehinger
 * @version $Id: mapcontrolview.h,v 1.6 2002/01/04 21:09:01 heiner Exp $
 */
class MapControlView : public QWidget
{
  Q_OBJECT

  public:
    /**
     * Creates all needed widgets.
     */
    MapControlView(QWidget *parent);
    /**
     * Destructor, does nothing special.
     */
    ~MapControlView();

  public slots:
    /**
     * Displays the map-data (height and width of the map, scale).
     */
    void slotShowMapData(QSize);
    /**
     * Sets the scale, called when the slider is moved.
     */
    void slotSetScale();
    /**
     * Shows the scale in the lcd-label and sets the slider.
     */
    void slotShowScaleChange(int value);
    /** */
    void slotSetMinMaxValue(int min, int max);

  signals:
    /** */
    void scaleChanged(double);

  private:
    /** */
    int __setScaleValue(int value);
    /** */
    int __getScaleValue(double value);

    QSlider* currentScaleSlider;
    QLCDNumber* currentScaleValue;
    QLabel* dimText;
};

#endif
