/***************************************************************************
                          kfocustask.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSTASK_H
#define KFOCUSTASK_H

#include <qobject.h>
#include <qdom.h>
#include <qdatetime.h>
class KFMEndDate;

/**Task object in the KFocus model.
  *@author Jeffrey Yu
  */

class KFMTask : public QObject  {
	Q_OBJECT
public: 
	KFMTask();
	KFMTask(const KFMTask* task);
	~KFMTask();
	
	int operator<(const KFMTask& other);
	int operator==(const KFMTask& other);

  /** Retrieve a QDomElement from the task */
  QDomElement domElement(QDomDocument* dDoc);
  /** Setup the task with data from a DOM element */
  void domElement(QDomElement eTask);

  /** Unique identifier for the task */
  virtual uint id() const;

  /** Retrieve the task's title */
  virtual QString title() const;
  /** Set the task's title */
  virtual void title(QString title);

  /** Get the task's comments */
  virtual QString comments() const;
  /** Set the task's comments */
  virtual void comments(QString comments);

	/** Test whether the task's startdate is in the past
			@return True if task has started
		*/
  bool started() const {return startDate_ <= QDate::currentDate();};

  /** Retrieve the task's startdate
  		@return Start date for the task
  	*/
  QDate startDate() const {return startDate_;};
  /** Select a new startdate
  		@param startDate Start date for the task
  	*/
  void startDate(const QDate startDate);

  /** Retrieve the task's enddate
  		@return End date for the task
  	*/
  KFMEndDate* endDate() const;
  /** Copy a task's enddate from a prototype
  		@param endDate Prototype enddate
  	*/
  void endDate(const KFMEndDate* endDate);
  /** Select the task's enddate
  		@param endDate End date for the task
  	*/
  void endDate(KFMEndDate* endDate);

  /** Retrieve the task's assigned position
  		@return Assigned position of the task
  	*/
  int position() const {return pos_;};
  /** Assign a position to the task
  		@param pos Position for the task
  	*/
  void position(const int pos) {pos_ = pos;};

signals: // Signals
  /** Signal sent when the contents change */
  void contentsChanged();
  /** Signal sent when the title text changes */
  void titleChanged();
  /** Signal sent when the comments change */
  void commentsChanged();
  /** Signal sent when the startdate changes */
  void startDateChanged();
  /** Signal sent when the enddate changes */
  void endDateChanged();

private: // Private attributes
  /** Unique task identifier */
  uint id_;
  /** Short task description */
  QString title_;
  /** Task comments */
  QString comments_;
  /** Task start date */
	QDate startDate_;
  /** Task end date */
  KFMEndDate* endDate_;
  /** Position in the tasklist */
  int pos_;

private slots:
	/** Slot to receive contentsChanged signals from the enddate component */
	void onEndDateContentsChanged();

};

#endif
