/***************************************************************************
                          kfocustaskpropsview.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qcheckbox.h>

#include "kfocustaskpropsview.h"
#include "kfocustask.h"
#include "kfvdate.h"
#include "kfmenddate.h"

KFVTask::KFVTask(QWidget *parent,	const char *name)
	: QGroupBox(parent,name)
{
	task_ = 0;
	taskChangeInProgress_ = false;
	setTitle("Task Information");
	setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding));
	setMargin(7);
	createWidgets();
	
	connect(leTitle_, SIGNAL(textChanged(const QString&)), this, SLOT(onLeTitleChanged(const QString&)));
	connect(mleComments_, SIGNAL(textChanged()), this, SLOT(onMleCommentsChanged()));
	connect(cbEndDate_, SIGNAL(toggled(bool)), this, SLOT(onCbEndDateToggled(bool)));
	
	resetContents();	
}

KFVTask::~KFVTask(){
}


/** Read the current task */
KFMTask* KFVTask::task(){
	return task_;
}

/** Specify a task for the Task Properties view */
void KFVTask::task(KFMTask* task){
	if (task != task_) {
		/* Set a flag to true so methods further down in scope
				can selectively change their behavior */
		taskChangeInProgress_ = true;
		
		task_ = task;
		resetContents();
		
		taskChangeInProgress_ = false;
	}
}


/** Change the state of the title lineedit widget */
void KFVTask::titleLineEditSelected(bool /*selected*/){
	if (true) {
		leTitle_->selectAll();
		leTitle_->setFocus();	
		leTitle_->setCursorPosition(0);
	}
}


/** Create widgets for the TaskProps view */
void KFVTask::createWidgets(){
	
	QVBoxLayout* vbl1 = new QVBoxLayout(this);
		vbl1->setMargin(20);
		vbl1->setSpacing(7);

		// Properties Panel
		QVBoxLayout* vbl2 = new QVBoxLayout(vbl1);
			
			// Title label and editbox
			QHBoxLayout* hblTitle = new QHBoxLayout(vbl2);
				hblTitle->addWidget(new QLabel("Title  ", this));
				hblTitle->addWidget(leTitle_ = new QLineEdit(this));
	
			// Comment label and editbox
			QVBoxLayout* vblComments = new QVBoxLayout(vbl2);
				vblComments->addWidget(new QLabel("Comments  ", this));
				vblComments->addWidget(mleComments_ = new QMultiLineEdit(this));
					mleComments_->setWordWrap(QMultiLineEdit::WidgetWidth);
					
			// Startdate controls
			createWidgetsStartDate(this, vbl2);
										
			// Enddate controls
			createWidgetsEndDate(this, vbl2);
}


/** Create widgets for the startdate */
void KFVTask::createWidgetsStartDate(QWidget* parent, QLayout* parentLayout){
	QHBoxLayout* hbl1 = new QHBoxLayout(parentLayout);
		hbl1->addWidget(new QLabel("Start date", parent));
		hbl1->addWidget(dvStartDate_ = new KFVDate(parent));
			dvStartDate_->setEnabled(true);
			connect(dvStartDate_, SIGNAL(dateChanged(const QDate&)), this,
					SLOT(onDvStartDateDateChanged(const QDate&)));
}


/** Create widgets for the enddate */
void KFVTask::createWidgetsEndDate(QWidget* parent, QLayout* parentLayout){
		QHBoxLayout* hbl1 = new QHBoxLayout(parentLayout);
			hbl1->addWidget(cbEndDate_ = new QCheckBox("End date", parent));
			hbl1->addWidget(dvEndDate_ = new KFVDate(parent));
}


/** Set the values in input fields back to their defaults. */
void KFVTask::resetContents(){
	if (task_ == 0) {
		// Disable task view
		setEnabled(false);
		
		// Update enddate widgets
		cbEndDate_->setChecked(false);
		dvEndDate_->date(QDate::currentDate());
				
		// Update startdate widgets
		dvStartDate_->date(QDate::currentDate());
		
		// Update comments widgets
		mleComments_->setText("");
		
		// Update title widgets
		leTitle_->setText("");
	}
	else {
		// Update title widgets
		leTitle_->setText(task_->title());
		leTitle_->setCursorPosition(0);
		
		// Update comments widgets
		mleComments_->setText(task_->comments());
		mleComments_->setCursorPosition(0,0);
		
		// Update startdate widgets
		dvStartDate_->date(task_->startDate());
		
		// Update enddate widgets
		switch(task_->endDate()->type()){
			case KFMEndDate::Absolute:
				/* Update dvEndDate first because checking cbEndDate triggers
						slot onCbEndDateToggled(bool). */
				dvEndDate_->date(task_->endDate()->date());
				cbEndDate_->setChecked(true);
				break;
			default: /* KFMEndDate::NotADate */
				cbEndDate_->setChecked(false);
				dvEndDate_->date(QDate::currentDate());
				break;
		}
		
		// Enable task view
		setEnabled(true);
	}
	
}


/** Slot for changes to the title QLineEdit */
void KFVTask::onLeTitleChanged(const QString& text){
	if (task_ != NULL)
		task_->title(text);
}


/** Slot to receive changes to the comments QMultiLineEdit */
void KFVTask::onMleCommentsChanged(){
	if (task_ != NULL)
		task_->comments(mleComments_->text());
}


/** Slot to receive changes to the startdate view */
void KFVTask::onDvStartDateDateChanged(const QDate& date){
	if (task_ != NULL) {
		task_->startDate(date);
	}
}


/** Slot to receive toggles of the enddate checkbox */
void KFVTask::onCbEndDateToggled(bool on){
	if (on) {
		/* Update the view */
		dvEndDate_->setEnabled(true);
		connect(dvEndDate_, SIGNAL(dateChanged(const QDate&)), this,
				SLOT(onDvEndDateDateChanged(const QDate&)));
		
		/* Update the model */
		if (task_ != NULL && !taskChangeInProgress_) {
			task_->endDate()->type(KFMEndDate::Absolute);
			task_->endDate()->date(dvEndDate_->date());
		}
	}
	else {
		/* Update the view */
		disconnect(dvEndDate_, 0, this, 0);
		dvEndDate_->setEnabled(false);
		
		/* Update the model */
		if (task_ != NULL && !taskChangeInProgress_) {
			task_->endDate()->type(KFMEndDate::NotADate);
		}
	}
}


/** Slot to receive changes to the enddate view */
void KFVTask::onDvEndDateDateChanged(const QDate& date){
	if (task_ != NULL) {
		task_->endDate()->date(date);	
	}
}

