/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
#ifndef KFTPSERVERMANAGEMENTDIALOG_H
#define KFTPSERVERMANAGEMENTDIALOG_H

#include <kdialogbase.h>

class QGridLayout;

namespace KFTPWidgets {

namespace ServerManagement {

class ListViewItem;
class DialogWidget;

/**
 * @author Blacknator
 *
 * @brief this class represents a dialog
 *
 * the dialog configures itself. it depends on the values, ip-addresses and names the user must enter
 * to execute the site command sucessfull
 */
class Dialog : public KDialogBase
{
Q_OBJECT

public:
    Dialog();
    ~Dialog();

    /**
     * shows a dialog if the user must enter something
     * @param item the item that was double clicked
     */
    void showDialog(ListViewItem *item);

signals:
    /**
     * the command is send if the dialog exit
     * connected to KFTPServerManagementListView::slotSendCommand(QString)
     * @param execute true if no error occured, otherwise the dialog is showing again
     * @param command command to send
     */
    void command(bool execute, QString command);

private:
    bool checkArguments();
    void createDialog();

private slots:
    /** ok button of the dialog was pressed */
    void slotSendCommand();

private:
    QPtrList<DialogWidget> m_dialogWidgets;

    /** @brief the clicked item in the list view */
    ListViewItem *m_item;
    /** @brief the command to execute */
    QString m_command;

    /** @brief Dialog layout */
    QGridLayout *m_layout;
};

}

}

#endif
