/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configgeneral.h"

#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qstring.h>
#include <qfile.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qlineedit.h>

ConfigGeneral::ConfigGeneral(QWidget* parent, const char* name, WFlags fl)
	: ConfigGeneralLayout(parent, name, fl)
{
	m_selectBrowser->setPixmap(KGlobal::iconLoader()->loadIcon("fileopen",KIcon::Small,0,false));
	connect(m_selectBrowser, SIGNAL(clicked()), this, SLOT(slotSelectBrowser()));
}


ConfigGeneral::~ConfigGeneral()
{
}


void ConfigGeneral::setSavePassword(bool state)
{
	m_savePassword->setChecked(state);
	m_saveFile->setEnabled(state);
	m_saveWallet->setEnabled(state);
}


void ConfigGeneral::slotSelectBrowser()
{
	QString browserPath = KFileDialog::getOpenFileName(m_browserPath->text(), "", this, i18n("Select a file"));
	if (browserPath != QString::null)
	{
		if (QFile::exists(browserPath))
			m_browserPath->setText(browserPath);
	}
}


#include "configgeneral.moc"
