/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "trayicon.h"

#include <qpainter.h>
#include <qtooltip.h>

#include <kiconeffect.h>

TrayIcon::TrayIcon(const QString &title, const QPixmap &titleIcon, const QString &iconStr) : QObject()
{
	// Create and show the system tray icon
	m_systray = new MySystemTray(0, "KGmailNotifier");
	m_systray->setPixmap(m_systray->loadIcon(iconStr));
	m_systray->show();
	
	QObject::connect(m_systray, SIGNAL(mouseButtonPressed()), this, SLOT(slotMouseButtonPressed()));
	
	// Create and insert the app's title and icon into the menu
	m_popupTitle = new KPopupTitle();
	m_popupTitle->setTitle(title, &titleIcon);
	m_systray->contextMenu()->insertItem(m_popupTitle);
}


TrayIcon::~TrayIcon()
{
	if (m_systray)
		delete m_systray;

	if (m_popupTitle)
		delete m_popupTitle;
}


// Private slot
void TrayIcon::slotMouseButtonPressed()
{
	emit trayIconClicked();
}


// Public methods
int TrayIcon::addItemToMenu(const QPixmap &icon, const QString &title, const QObject *receiver, const char *slot)
{
	return m_systray->contextMenu()->insertItem(QIconSet(icon), title, receiver, slot);
}


int TrayIcon::addItemToMenu(const QString &title, const QObject *receiver, const char *slot)
{
	return m_systray->contextMenu()->insertItem(title, receiver, slot);
}


void TrayIcon::addSeparatorToMenu()
{
	m_systray->contextMenu()->insertSeparator();
}


void TrayIcon::setItemChecked(const int itemID)
{
	if (m_systray->contextMenu()->isItemChecked(itemID))
		m_systray->contextMenu()->setItemChecked(itemID, false);
	else
		m_systray->contextMenu()->setItemChecked(itemID, true);
}


bool TrayIcon::itemChecked(const int itemID) const
{
	return m_systray->contextMenu()->isItemChecked(itemID);
}


void TrayIcon::setIcon(const QString &iconStr, const bool showNumber, const unsigned int number)
{
	if (showNumber) // Display number on systray
	{
		if (number > 0) // Don't display zero
		{
			QFont f;
			f.setPixelSize(14);
			f.setWeight(QFont::Black);

			KIconEffect iconEffect;
			QPixmap srcIcon = m_systray->loadIcon(iconStr);
			QPixmap dstIcon = iconEffect.apply(srcIcon, KIconEffect::ToGamma, 1.0, QColor(255,255,255), false);

			QPainter p(&dstIcon);
			p.setFont(f);
			p.setPen(Qt::black);
			p.drawText(0, 0, 23, 23, Qt::AlignCenter, QString::number(number));

			m_systray->setPixmap(dstIcon);
		}
		else
			m_systray->setPixmap(m_systray->loadIcon(iconStr));
	}

	else
		m_systray->setPixmap(m_systray->loadIcon(iconStr));

	m_systray->show();
}

void TrayIcon::setToolTip(const QString &text)
{
	QToolTip::remove(m_systray);
	QToolTip::add(m_systray, text);
}

#include "trayicon.moc"
