/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TRAYICON_H
#define TRAYICON_H

#include "mysystemtray.h"
#include <kpopupmenu.h>

class TrayIcon : public QObject
{
	Q_OBJECT
public:
	TrayIcon(const QString &title, const QPixmap &titleIcon, const QString &iconStr);
	~TrayIcon();

	int addItemToMenu(const QPixmap &icon, const QString &title, const QObject *receiver, const char *slot);
	int addItemToMenu(const QString &title, const QObject *receiver, const char *slot);
	void addSeparatorToMenu();
	void setItemChecked(const int itemID);
	bool itemChecked(const int itemID) const;
	void setIcon(const QString &iconStr, const bool showNumber, const unsigned int number);
	void setToolTip(const QString &text);

private:
	TrayIcon(const TrayIcon&);
	TrayIcon& operator=(const TrayIcon&);

	MySystemTray *m_systray;
	KPopupTitle *m_popupTitle;

private slots:
	void slotMouseButtonPressed();
	
signals:
	void trayIconClicked();
};

#endif
