/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "confignotification.h"

#include <KFileDialog>
#include <KLocale>
#include <KStandardDirs>

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

ConfigNotification::ConfigNotification(QWidget* parent)
    : QWidget(parent)
{
    m_ui.setupUi(this);
    m_ui.SelectSoundfile->setIcon(KIcon("document-open"));
    connect(m_ui.SelectSoundfile, SIGNAL(clicked()), this, SLOT(slotSelectSoundFile()));
}

// ------------------------------------------------------------------------------------------------------------------- //

ConfigNotification::~ConfigNotification()
{
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Private slots                                                                                                    //
// ------------------------------------------------------------------------------------------------------------------- //

void ConfigNotification::slotSelectSoundFile()
{
    QString soundsDir = m_ui.kcfg_SoundFile->text();
    if (soundsDir.isEmpty())
        soundsDir = KStandardDirs::locate("sound", "");
        
    QString soundfile = KFileDialog::getOpenFileName(soundsDir, "*.wav *.ogg *.mp3", this, i18n("Select a file"));

    if (soundfile != QString::null)
    {
        if (QFile::exists(soundfile))
            m_ui.kcfg_SoundFile->setText(soundfile);
    }
}

// ------------------------------------------------------------------------------------------------------------------- //

#include "confignotification.moc"
