/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "configurationdialog.h"

#include <KLocale>

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

ConfigurationDialog::ConfigurationDialog(KConfigSkeleton *config)
    : KConfigDialog(0, "Preferences", config)
{
    // Add general options page
    m_configGeneralPage = new ConfigGeneral(this);
    this->addPage(m_configGeneralPage, i18n("General"), "configure");

    // Add appearance options page
    m_configAppearancePage = new ConfigAppearance(this);
    this->addPage(m_configAppearancePage, i18n("Appearance"), "preferences-desktop");

    // Add notification options page
    m_configNotificationPage = new ConfigNotification(this);
    this->addPage(m_configNotificationPage, i18n("Notification"), "preferences-desktop-notification");

    this->showButtonSeparator(true);
}

// ------------------------------------------------------------------------------------------------------------------- //

ConfigurationDialog::~ConfigurationDialog()
{
    if (m_configGeneralPage)
        delete m_configGeneralPage;

    if (m_configAppearancePage)
        delete m_configAppearancePage;

    if (m_configNotificationPage)
        delete m_configNotificationPage;
}

// ------------------------------------------------------------------------------------------------------------------- //

#include "configurationdialog.moc"
