/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef TRAYICON_H
#define TRAYICON_H

#include <KSystemTrayIcon>

class TrayIcon : public KSystemTrayIcon
{
    Q_OBJECT
public:
    TrayIcon(QWidget *parent);
    ~TrayIcon();

    void setIcon(const QPixmap &icon, const bool showNumber, const unsigned int number);

private:
    TrayIcon(const TrayIcon&);
    TrayIcon& operator=(const TrayIcon&);

private slots:
    void slotActivated(QSystemTrayIcon::ActivationReason reason);

signals:
    void clicked();
};

#endif
