/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "grubentrypreview.h"

//Qt
#include <qdir.h>

//KDE
#include <kstandarddirs.h>
#include <klocale.h>

GRUBEntryPreview::GRUBEntryPreview( QWidget *parent ) : QTextEdit( parent )
{
}
GRUBEntryPreview::GRUBEntryPreview( const GRUB::ConfigFile::Entry entry, QWidget *parent ) : QTextEdit( parent )
{
	previewEntry( entry );
}

void GRUBEntryPreview::previewEntry( const GRUB::ConfigFile::Entry entry )
{
	QString details;

	QDir iconsDir( KStandardDirs::locate( "data", "kgrubeditor/icons/" ) );
	foreach( const QString &icon, iconsDir.entryList( QStringList( "*.png" ) ) )
	{
		if ( entry.title().contains( QString( icon ).remove( ".png" ), Qt::CaseInsensitive ) )
		{
			details.append( "<img src=" + iconsDir.absoluteFilePath( icon ) + ">" );
			break;
		}
	}

	details.append( "<h2>" + entry.title() + "</h2>" );
	if ( !entry.root().isEmpty() )
		details.append( "<b>" + i18nc( "@info", "Root" ) + ":</b> " + entry.root() );
	if ( !entry.kernel().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Kernel (File)" ) + ":</b> " + entry.kernel().kernel() );
	if ( !entry.kernel().arguments().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Kernel (Arguments)" ) + ":</b> " + entry.kernel().arguments() );
	if ( !entry.initrd().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Initrd" ) + ":</b> " + entry.initrd() );
	if ( entry.lock() )
		details.append( "<br/><b>" + i18nc( "@info", "Locked" ) + ":</b> " + i18nc( "@info:status", "Yes" ) );
	if ( !entry.password().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Password (Text)" ) + ":</b> " + entry.password().password() );
	if ( entry.password().md5crypted() )
		details.append( "<br/><b>" + i18nc( "@info", "Password (MD5 Encrypted)" ) + ":</b> " + i18nc( "@info:status", "Yes" ) );
	if ( !entry.password().configFile().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Password (Menu File To Load)" ) + ":</b> " + entry.password().configFile() );
	if ( !entry.color().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Colors" ) + ":</b> " + entry.color().result() );
	if ( entry.makeActive() )
		details.append( "<br/><b>" + i18nc( "@info", "MakeActive" ) + ":</b> " + i18nc( "@info:status", "Yes" ) );
	if ( entry.saveDefault() )
		details.append( "<br/><b>" + i18nc( "@info", "SaveDefault" ) + ":</b> " + i18nc( "@info:status", "Yes" ) );
	if ( !entry.chainLoader().isEmpty() )
		details.append( "<br/><b>" + i18nc( "@info", "Chainloader" ) + ":</b> " + entry.chainLoader() );
	if ( !entry.maps().isEmpty() )
		foreach( const GRUB::ComplexCommand::Map &map, entry.maps() )
			details.append( "<br/><b>" + i18nc( "@info", "Map" ) + ":</b> " + map.result() );

	clear();
	setHtml( details );
}

#include "grubentrypreview.moc"
