/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef UI_KGRUBEDITOR_H
#define UI_KGRUBEDITOR_H

//Qt
#include <qheaderview.h>

//KDE
#include <kpagewidget.h>
#include <ktabwidget.h>
#include <kaction.h>
#include <kmenu.h>

//Ui
#include "ui_mainwindow_entries.h"

#include "ui_mainwindow_general.h"
#include "ui_mainwindow_password.h"
#include "ui_mainwindow_background.h"
#include "ui_mainwindow_color.h"
#include "ui_mainwindow_map.h"

#include "ui_mainwindow_tools.h"

class Ui_KGRUBEditor
{
public:
	Ui::mainwindow_entries ui_entries;

	Ui::mainwindow_general ui_general;
	Ui::mainwindow_password ui_password;
	Ui::mainwindow_background ui_background;
	Ui::mainwindow_color ui_color;
	Ui::mainwindow_map ui_map;

	Ui::mainwindow_tools ui_tools;
//GRUB Entries
	QWidget *entries;
	KMenu *edit;
		KAction *action_quickEditor;
		KAction *action_fullEditor;
//GRUB Settings
	QWidget *general;
	QWidget *password;
	QWidget *background;
	QWidget *color;
	QWidget *map;
		KTabWidget *settings;
//GRUB Device Naming
	QWidget *tools;
//Global
	KPageWidget *pageWidget;
		QVBoxLayout *mainLayout;

	void setupUi( KCModule *KGRUBEditor )
	{
		pageWidget = new KPageWidget;
//GRUB Entries
		ui_entries.setupUi( entries = new QWidget( pageWidget ) );
		ui_entries.entryWidget->header()->setResizeMode( 0, QHeaderView::Stretch );
		ui_entries.entryWidget->header()->setResizeMode( 1, QHeaderView::ResizeToContents );
		ui_entries.entryWidget->header()->setStretchLastSection( false );

		edit = new KMenu( ui_entries.kpushbutton_edit );
		action_quickEditor = new KAction( i18nc( "@action:inmenu", "Quick Editor" ), edit );
		edit->addAction( action_quickEditor );
		action_fullEditor = new KAction( i18nc( "@action:inmenu", "Full Editor" ), edit );
		edit->addAction( action_fullEditor );

		ui_entries.kpushbutton_up->setIcon( KIcon( "arrow-up" ) );
		ui_entries.kpushbutton_down->setIcon( KIcon( "arrow-down" ) );
		ui_entries.kpushbutton_add->setIcon( KIcon( "list-add" ) );
		ui_entries.kpushbutton_edit->setIcon( KIcon( "document-properties" ) );
		ui_entries.kpushbutton_edit->setMenu( edit );
		ui_entries.kpushbutton_remove->setIcon( KIcon( "list-remove" ) );
		ui_entries.kpushbutton_details->setIcon( KIcon( "help-about" ) );

		ui_entries.kpushbutton_back->setIcon( KIcon( "go-previous" ) );
//GRUB Settings
		settings = new KTabWidget( pageWidget );

		ui_general.setupUi( general = new QWidget( settings ) );

		ui_password.setupUi( password = new QWidget( settings ) );
		ui_password.kpushbutton_create->setIcon( KIcon( "dialog-password" ) );
		ui_password.kpushbutton_edit->setIcon( KIcon( "document-properties" ) );
		ui_password.kpushbutton_delete->setIcon( KIcon( "edit-delete" ) );

		ui_background.setupUi( background = new QWidget( settings ) );
		ui_background.toolButton_browse->setIcon( KIcon( "document-open" ) );
		ui_background.kpushbutton_create->setIcon( KIcon( "insert-image" ) );
		ui_background.kpushbutton_getSplash->setIcon( KIcon( "get-hot-new-stuff" ) );
		ui_background.kpushbutton_preview->setIcon( KIcon( "image-png" ) );
// 		ui_background.kpushbutton_getGfxboot->setIcon( KIcon( "get-hot-new-stuff" ) );

		ui_color.setupUi( color = new QWidget( settings ) );

		ui_map.setupUi( map = new QWidget( settings ) );
		ui_map.kpushbutton_add->setIcon( KIcon( "list-add" ) );
		ui_map.kpushbutton_edit->setIcon( KIcon( "document-properties" ) );
		ui_map.kpushbutton_remove->setIcon( KIcon( "list-remove" ) );

		settings->addTab( general, KIcon( "preferences-other" ), i18nc( "@title:tab", "General" ) );
		settings->addTab( password, KIcon( "security-high" ), i18nc( "@title:tab", "Password" ) );
		settings->addTab( background, KIcon( "preferences-desktop-wallpaper" ), i18nc( "@title:tab", "Background" ) );
		settings->addTab( color, KIcon( "fill-color" ), i18nc( "@title:tab", "Color" ) );
		settings->addTab( map, KIcon( "drive-harddisk" ), i18nc( "@title:tab", "Maps" ) );
//GRUB Device Naming
		ui_tools.setupUi( tools = new QWidget( pageWidget ) );
		ui_tools.kpushbutton_backup->setIcon( KIcon( "document-save-all" ) );
		ui_tools.kpushbutton_install->setIcon( KIcon( "computer" ) );
		ui_tools.kpushbutton_devices->setIcon( KIcon( "drive-harddisk" ) );
		ui_tools.kpushbutton_files->setIcon( KIcon( "view-list-text" ) );
		ui_tools.kpushbutton_preferences->setIcon( KIcon( "preferences-system" ) );
//Global
		KPageWidgetItem *entriesPage = new KPageWidgetItem( entries, i18nc( "@title:column", "Entries" ) );
		entriesPage->setHeader( i18nc( "@title", "GRUB Boot List" ) );
		entriesPage->setIcon( KIcon( "view-list-details" ) );
		pageWidget->addPage( entriesPage );

		KPageWidgetItem *settingsPage = new KPageWidgetItem( settings, i18nc( "@title:column", "Options" ) );
		settingsPage->setHeader( i18nc( "@title", "GRUB Configuration Options" ) );
		settingsPage->setIcon( KIcon( "configure" ) );
		pageWidget->addPage( settingsPage );

		KPageWidgetItem *toolsPage = new KPageWidgetItem( tools, i18nc( "@title:column", "Tools" ) );
		toolsPage->setHeader( i18nc( "@title", "GRUB Management Tools" ) );
		toolsPage->setIcon( KIcon( "preferences-system" ) );
		pageWidget->addPage( toolsPage );

		mainLayout = new QVBoxLayout( KGRUBEditor );
		mainLayout->setMargin( 0 );
		mainLayout->setSpacing( KDialog::spacingHint() );
		mainLayout->addWidget( pageWidget );
	}
};

namespace Ui
{
    class KGRUBEditor : public Ui_KGRUBEditor {};
}

#endif
