/*
 *  Wrapper/Interface class for GstAutoplugFactory
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "autoplugfactory.h"
#include "autoplug.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_AUTOPLUG_FACTORY(m_real)

AutoplugFactory::AutoplugFactory(void *real) :
	SimpleWrapper(real) {
}

AutoplugFactory::~AutoplugFactory() {
	if (m_real)
		gst_autoplug_factory_destroy(r());
}

AutoplugFactory* AutoplugFactory::wrap(void *real) {
	return (AutoplugFactory*) SimpleWrapper::wrap(real);
}

AutoplugFactory* AutoplugFactory::find(const QString &name) {
	return AutoplugFactory::wrap(gst_autoplug_factory_find(name.latin1()));
}

Autoplug* AutoplugFactory::create() {
	return Autoplug::wrap(gst_autoplug_factory_create(r()));
}

Autoplug* AutoplugFactory::make(const QString &name) {
	return Autoplug::wrap(gst_autoplug_factory_make(name.latin1()));
}


