/*
 *  Wrapper/interface class for GstAutoplugFactory
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_EVENT_H
#define KDE_GST_EVENT_H

#include <kde/gst/simplewrapper.h>

namespace KDE {
namespace GST {
	class Autoplug;

/**
 * An autoplugfactory is used to create instances of an autoplugger. 
 * Use @ref AutoplugFactory#find() to find a named autoplugfactory.
 * @ref #getList() to get a  list of all available autopluggers.
 * 
 * Once an autoplugfactory has been obtained use 
 * @ref AutoplugFactory#create() to instantiate a real autoplugger. 
 * Optionally @ref AutoplugFactory#make() to create a autoplugger 
 * from the named factory.
 * Use a regular delete to remove the factory from the global list.
 *
 * @short Create autopluggers from a factory.
 * @see Autoplug
 */
	class AutoplugFactory : public SimpleWrapper {
	private:
		void *reserved;
			
	public:

/**
 * Creates a new AutoplugFactory that wrapps the given GstAutoplugFactory.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstAutoplugFactory to be wrapped.
 */
	        AutoplugFactory(void *real);
	        virtual ~AutoplugFactory();

/**
 * Creates a new AutoplugFactory that wrapps the given object. Unlike the
 * constructor this re-used already existing objects.
 * @param real the object to be wrapped
 * @return the AutoplugFactory
 */
		static AutoplugFactory *wrap(void *real);

/**
 * Search for an autoplugfactory of the given name.
 *
 * @return AutoplugFactory if found, NULL otherwise
 */
		static AutoplugFactory* find(const QString &name);

/**
 * Create a new Autoplug instance from the 
 * given autoplugfactory.
 *
 * @return A new Autoplug instance.
 */
		Autoplug* create();

/**
 * Create a new #GstAutoplug instance from the 
 * autoplugfactory with the given name.
 *
 * @return A new Autoplug instance.
 */
		static Autoplug* make(const QString &name);
	};
}
}

#endif
