/*
 *  Interface/wrapper for GStreamer GstBin
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "bin.h"
#include "clock.h"
#include "helper.h"
#include "callbackmanager.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_BIN(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* Bin::wrapperFactory(void *real) {
	return new Bin(real);
}

Bin::Bin(void *real) :
	Element(real) {
}
Bin::~Bin() {
}

Bin* Bin::wrap(void *real) {
	return (Bin*) Element::wrap(real);
}

Bin::Bin(const QString &name) :
	Element(0) {
	m_real = gst_bin_new(name.latin1());
	registerReal();
}

void Bin::add(Element *elem1,
	      Element *elem2,
	      Element *elem3,
	      Element *elem4,
	      Element *elem5) {
	if (!elem2) 
		gst_bin_add(r(), GST_ELEMENT(elem1->realObject()));
	else if (!elem3)
		gst_bin_add_many(r(), 
				 GST_ELEMENT(elem1->realObject()),
				 GST_ELEMENT(elem2->realObject()),
				 0);
	else if (!elem4)
		gst_bin_add_many(r(), 
				 GST_ELEMENT(elem1->realObject()),
				 GST_ELEMENT(elem2->realObject()),
				 GST_ELEMENT(elem3->realObject()),
				 0);
	else if (!elem5)
		gst_bin_add_many(r(), 
				 GST_ELEMENT(elem1->realObject()),
				 GST_ELEMENT(elem2->realObject()),
				 GST_ELEMENT(elem3->realObject()),
				 GST_ELEMENT(elem4->realObject()),
				 0);
	else
		gst_bin_add_many(r(), 
				 GST_ELEMENT(elem1->realObject()),
				 GST_ELEMENT(elem2->realObject()),
				 GST_ELEMENT(elem3->realObject()),
				 GST_ELEMENT(elem4->realObject()),
				 GST_ELEMENT(elem5->realObject()),
				 0);
}

void Bin::remove(Element *element) {
	gst_bin_remove(r(), GST_ELEMENT(element->realObject()));
}

Element *Bin::getByName(const QString &name) {
	return Element::wrap(gst_bin_get_by_name(r(), name.latin1()));
}

Element *Bin::getByNameRecurseUp(const QString &name) {
	return Element::wrap(gst_bin_get_by_name_recurse_up(r(), 
							    name.latin1()));
}

QValueVector<Element*> Bin::getList() {
	return convertList<Element>(gst_bin_get_list(r()));
}

void Bin::autoClock() {
	gst_bin_auto_clock(r());
}

Clock* Bin::getClock() {
	return Clock::wrap(gst_bin_get_clock(r()));
}

void Bin::useClock(Clock *clock) {
	gst_bin_use_clock(r(), GST_CLOCK(clock->realObject()));
}

bool Bin::iterate() {
	return gst_bin_iterate(r());
}

namespace {
	void prePostCallback(GstBin *e, gpointer cookie) {
		CallbackData *cd = (CallbackData*) cookie;
		void (*callback)(Bin*,void *) = 
			(void (*)(Bin*,void*)) cd->origCallback;
		(*callback)(Bin::wrap(e), cd->cookie);
	}
}

void Bin::setPreIterateFunction(void (*func)(Bin *bin, void *data), 
				void *cookie) {
	getCBManager()->removeAllWrappedCallbacks("bin-pre-iterate");

	CallbackData *cd = 
		getCBManager()->registerWrappedCallback("bin-pre-iterate",
							(void*)prePostCallback, 
							(void*)func, 
							cookie,
							false);
	gst_bin_set_pre_iterate_function(r(), 
					 (GstBinPrePostIterateFunction)cd->wrapCallback, 
					 cd);
}

void Bin::setPostIterateFunction(void (*func)(Bin *bin, void *data), 
				 void *cookie) {
	getCBManager()->removeAllWrappedCallbacks("bin-post-iterate");

	CallbackData *cd = 
		getCBManager()->registerWrappedCallback("bin-post-iterate",
							(void*)prePostCallback, 
							(void*)func, 
							cookie,
							false);
	gst_bin_set_post_iterate_function(r(), 
					  (GstBinPrePostIterateFunction)cd->wrapCallback, 
					  cd);
}

#include "bin.moc"

