/*
 *  Interface/wrapper for GStreamer GstDParamManager
 *  Copyright (C) 2003 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 2001 Steve Baker <stevebaker_org@yahoo.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_DP_DPARAMMANAGER_H
#define KDE_GST_DP_DPARAMMANAGER_H

#include <kde/gst/object.h>

namespace KDE {
namespace GST {
	class Element;

namespace DP {
	class DParam;

/**
 */
	class DParamManager : public KDE::GST::Object {
	Q_OBJECT
	private:
                friend class GStreamer;
                static Wrapper* wrapperFactory(void *real);
		void *reserved;
		
	public:

/**
 * Creates a new DParamManager that wrapps the given GstDParamManager. 
 * Usually you really don't want to call this, use @ref #wrap instead.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstDParamManager to be wrapped
 */
	        DParamManager(void *real);
	        virtual ~DParamManager();

/**
 * Creates a new DParamManager that wrapps the given GstDParamManager. 
 * Unlike the DParamManager constructor this function also re-uses 
 * existing wrapper objects.
 *
 * @param real the GstDParamManager to be wrapped
 * @return the wrapped DParamManager
 */
		static DParamManager* wrap(void *real);

/**
 * Gets the DParamManager of the given @p element.
 * @return the DParamManager, or 0 if it does not exist
 */
		static DParamManager *getManager(KDE::GST::Element *element);

/**
 * Creates a new DParamManager instance.
 * @param name name of the DParamManager instance
 * @parent element which created this instance
 */
		DParamManager(const QString &name, KDE::GST::Element *element);

/**
 * Attach a @ref DParam to this DParamManager.
 *
 * @param dparamName a name previously added with gst_dpman_add_required_dparam
 * @param dparam GstDParam instance to attach
 * @return true if it was successfully attached
 */
		bool attachDParam(const QString &dparamName, KDE::GST::DP::DParam *dparam);

/**
 * Detach a @ref DParam of this DParamManager.
 *
 * @param dpman GstDParamManager instance
 * @param dparamName the name of a parameter with a previously attached GstDParam
 */
		void detachDPparam(const QString dparamName);
		
/**
 * Returns the DParam with the given name.
 * 
 * @param dpman DParamManager instance
 * @param name the name of an existing dparam instance
 * @return the DParam with the given name - or 0 otherwise
 */
		DParam *getDParam(const QString &name);

/**
 * Sets the rate of the DParamManager.
 * (More info desired)
 * @param rate the new rate
 */
		void setRate(int rate);

/**
 * Sets the parent of this DParamManager.
 *
 * @param parent the element that this DParamManager belongs to
 */
		void setParent(KDE::GST::Element *parent);

/**
 * Sets the mode of this DParamManager.
 *
 * @param mode the new mode
 */
		void setMode(const QString &mode);


	};
}
}
}
#endif
