/*
 *  Interface/wrapper for GStreamer GstParse
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "parse.h"
#include "bin.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

Bin *launch(const QString &pipelineDescription,
	    QString &errorMsg) {
	GstBin *b;
	GError *error = 0;
	b = gst_parse_launch(pipelineDescription.latin1(),
			     &error);
	if (!b) {
		errorMsg = QString(error->message);
		return 0;
	}
	return Bin::wrap(b);
}

Bin *launchv(const char **argv, QString &errorMsg) {
	GstBin *b;
	GError *error = 0;
	b = gst_parse_launchv(argv, &error);
	if (!b) {
		errorMsg = QString(error->message);
		return 0;
	}
	return Bin::wrap(b);
}

