/*
 *  Interface/wrapper for GStreamer GstSystemClock
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_SYSTEMCLOCK_H
#define KDE_GST_SYSTEMCLOCK_H

namespace KDE {
namespace GST {
	class Clock;

/**
 * The System clock is an implementation of @ref Clock using the
 * system time.
 * 
 * @short A default clock that uses the current system time
 * @see Clock
 */
	class SystemClock {
	private:
		void *reserved;
			
	public:
/**
 * Get a handle to the default system clock.
 *
 * @return the default clock.
 */
		static Clock *obtain();
	};
}
}

#endif
