/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// lib specific
#include "tip.h"


namespace Khalkhi {

void Tip::initiate( bool Complete )
{
    if( Complete )
        Data += QString::fromLatin1( "<qt>" );

    Data += QString::fromLatin1(
      "<table cellpadding=\"0\" cellspacing=\"1\">"
        "<tr><td align=\"right\" valign=\"top\">" );
}


void Tip::finalize( bool Complete )
{
    Data += QString::fromLatin1(
        "</td></tr>"
      "</table>" );

    if( Complete )
        Data += QString::fromLatin1( "</qt>" );
}


void Tip::appendHeader( const QString &ImageURL, const QString &RealName,
                                const QString &Role, const QString &Organization )
{
    const QString HeadTemplate = QString::fromLatin1(
        "<img src=\"%1\" width=\"50\"></td><td align=\"left\" valign=\"top\">"
            "<font size=\"+1\"><b>%2</b></font>%3<br>" );

    const QString Break = QString::fromLatin1( "<br>" );
    QString RO;
    if( !Role.isEmpty() )
        RO += Break + Role;
    if( !Organization.isEmpty() )
        RO += Break + Organization;

    Data.append( HeadTemplate.arg(ImageURL,RealName,RO) );
}


void Tip::appendStatus( const QString &Entry, const QString &Status )
{
    QString E = Status.isEmpty() ? QString::fromLatin1( "<br>%1" ).arg( Entry ) :
         QString::fromLatin1( "<br>%1<br><font size=\"-1\">%2</font>" ).arg( Entry, Status );

    Data.append( E );
}

}
