/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/



#ifndef KHALKHI_TIP_H
#define KHALKHI_TIP_H

// qt specific
#include <qstring.h>
// kde
#include <kdemacros.h>


namespace Khalkhi {

class KDE_EXPORT Tip
{
public:
    Tip();
    ~Tip();

public:
    QString data() const;

public:
    void initiate( bool Complete = true );
    void appendHeader( const QString &ImageURL, const QString &RealName,
                       const QString &Role, const QString &Organization );
    void appendStatus( const QString &Entry, const QString &Status = QString::null );
    void finalize( bool Complete = true );

protected:
    QString Data;
};


inline Tip::Tip()  {}
inline Tip::~Tip() {}

inline QString Tip::data() const { return Data; }

}

#endif
