/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qtooltip.h>
// kde specific
#include <kiconloader.h>
#include <kglobal.h>
#include <kpassivepopup.h>
// libs specific
#include <lazyfillmenu.h>
#include <menubutton.h>
// contactscore specific
#include <statusserviceclient.h>
#include <contactproperties.h>
// contactsgui specific
#include <contacticon.h>
#include <contact.h>
// applet specific
#include "contactmenufiller.h"
#include "contactmenubuttonfiller.h"


class StatusClientButtonProxy : public StatusServiceClient
{
public:
    StatusClientButtonProxy( ContactMenuButtonFiller *F ) : Filler( F ) {}
    virtual ~StatusClientButtonProxy() {}

public: // interface
    /** returns the contact for which the services are requested */
    virtual const KABC::Addressee& contact() const { return Filler->contact(); }

public: // slots interface
    /** called if the service switched */
    virtual void onStateChange( const ContactPropertyStatusService &Service, int Change,
                                int ItemIndex );
    virtual void onPropertyManagerChange() { Filler->updateImage(); }

protected:
    ContactMenuButtonFiller *Filler;
};

void StatusClientButtonProxy::onStateChange( const ContactPropertyStatusService &Service, int /*Change*/,
                                             int ItemIndex )
{
    Filler->updateImage();
    MenuButton *Button = Filler->button();
    if( Button )
    {
#if 0
        const ContactPropertyStatus Status = Service.status( Filler->contact(), ItemIndex, ContactService::ReferItem );

        QString Text = Status.data( DisplayTextRole ).asString();
        QImage Icon = Status.data( DisplayIconRole ).asImage();

        // enrich text with icon
        if( !Icon.isNull() )
        {
            QString IconId = QString::fromLatin1( "statuspopup" );//"%1_tipicon_%2_%3_%4" )
//               .arg( Status->id(), Filler->contact().uid(), PropertyId, ItemId );
            QMimeSourceFactory::defaultFactory()->setImage( IconId, Icon );
            Text = QString::fromLatin1( "<img src=\"%1\">&nbsp;%2" ).arg( IconId, Text );
        }
        Text = Filler->contact().realName() + "<br>"+ Text;

//         KPassivePopup::message( Text, Button );
#endif
    }
}



ContactMenuButtonFiller::ContactMenuButtonFiller( const KABC::Addressee C )
: Contact( C ), Button( 0 ), StatusProxy( new StatusClientButtonProxy(this) )
{
     ContactProperties::self()->registerClient( StatusProxy );
}

void ContactMenuButtonFiller::fill( MenuButton *B )
{
    Button = B;

    Button->setMenu( new LazyFillMenu(new ContactMenuFiller(Contact),false,Button) );
    Button->setTitel( Contact.realName() );
    Button->setDrawArrow( false );

    fillIcon( Button );
}


void ContactMenuButtonFiller::fillIcon( MenuButton *Button )
{
    QToolTip::add( Button, ContactRichTexter::self()->createContactTip(Contact) );

    int PixmapSize = Button->pixmapSize();
    // get some icon to display in front
    KABC::Picture ABCPicture = Contact.photo();
    if( ABCPicture.data().isNull() )
        ABCPicture = Contact.logo();

    // any picture?
    bool HasPicture = ABCPicture.isIntern() && !ABCPicture.data().isNull();

    QImage Pixmap = HasPicture ? ABCPicture.data()
                    : KGlobal::iconLoader()->loadIcon( "personal",KIcon::NoGroup,PixmapSize ).convertToImage();

    ContactIcon Icon( PixmapSize );
    Icon.appendIcon( Pixmap );
    Icon.fill( Contact );

    Button->setIcon( Icon.data() );
}


void ContactMenuButtonFiller::updateImage()
{
    if( Button ) fillIcon( Button );
}

ContactMenuButtonFiller::~ContactMenuButtonFiller()
{
    ContactProperties::self()->unregisterClient( StatusProxy );

    delete StatusProxy;
}
