/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PREFSWINDOW_H
#define PREFSWINDOW_H

#include <qlistbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include "prefswindow.h"
#include "kiaxprefs.h"
#include <qbuttongroup.h>

class KiaxPrefsWindow : public KiaxPrefsWindowUi
{
  Q_OBJECT

public:
  KiaxPrefsWindow(KiaxPrefs * iaxSettings, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KiaxPrefsWindow();
  /*$PUBLIC_FUNCTIONS$*/
  
public:
  
  KiaxPrefs* settings;

public:
  
  void setAccountValues(int accountNumber);
  void setFieldsValues(int accNumber);
  void setAudioValues();
  void setAudioFields();
  void setMiscValues();
  void setMiscFields();  
  void loadAccountsList();
  void enableControls(bool en);

private:
  QString getSelectedCodecName();
  void setCodecByName(QString codecName);
  void initWidgets();
  
private:
  int edittedAccNumber;
        
public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          accountSelected(int accNumber);
  virtual void          makeDefaultClicked();
  virtual void          deleteAccountClicked();
  virtual void          newAccountClicked();
  virtual void	      accountNameEdit_lostFocus();
  virtual void          buttonOk_clicked();
  virtual void		executeCommandCheckbox_toggled(bool checked);
};

#endif

