/////////////////////////////////////////////////////////////////////////////
// Name:        dialog_edit_label.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     19/02/2006 15:46:26
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 19/02/2006 15:46:26

/* This is the dialog box for labels, glob. labels and graphic texts edition */

////@begin includes
////@end includes

#include "dialog_edit_label.h"

////@begin XPM images
////@end XPM images

/*!
 * WinEDA_LabelPropertiesFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_LabelPropertiesFrame, wxDialog )

/*!
 * WinEDA_LabelPropertiesFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_LabelPropertiesFrame, wxDialog )

////@begin WinEDA_LabelPropertiesFrame event table entries
    EVT_BUTTON( wxID_OK, WinEDA_LabelPropertiesFrame::OnOkClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_LabelPropertiesFrame::OnCancelClick )

////@end WinEDA_LabelPropertiesFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_LabelPropertiesFrame constructors
 */

WinEDA_LabelPropertiesFrame::WinEDA_LabelPropertiesFrame( )
{
}

WinEDA_LabelPropertiesFrame::WinEDA_LabelPropertiesFrame( WinEDA_SchematicFrame* parent,
		DrawTextStruct * CurrentText,
		const wxPoint& pos,
		wxWindowID id, const wxString& caption, const wxSize& size, long style )
{
wxString msg;
	
	m_Parent = parent;
	m_CurrentText = CurrentText;
    Create(parent, id, caption, pos, size, style);
	m_TextLabel->SetValue(m_CurrentText->m_Text);
	m_TextLabel->SetFocus();
	switch( m_CurrentText->Type() )
	{
		case DRAW_GLOBAL_LABEL_STRUCT_TYPE:
			SetTitle(_("Global Label properties"));
			break;

		case DRAW_LABEL_STRUCT_TYPE:
			SetTitle(_("Label properties"));
 			break;

		default:
			SetTitle(_("Text properties"));
			break;
	}
	
    
	msg = m_SizeTitle->GetLabel() + ReturnUnitSymbol();
	m_SizeTitle->SetLabel(msg);
	
	msg = ReturnStringFromValue(g_UnitMetric, m_CurrentText->m_Size.x, m_Parent->m_InternalUnits);
	m_TextSize->SetValue(msg);
}

/*!
 * WinEDA_LabelPropertiesFrame creator
 */

bool WinEDA_LabelPropertiesFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_LabelPropertiesFrame member initialisation
    m_TextLabel = NULL;
    m_TextOrient = NULL;
    m_TextShape = NULL;
    m_SizeTitle = NULL;
    m_TextSize = NULL;
////@end WinEDA_LabelPropertiesFrame member initialisation

////@begin WinEDA_LabelPropertiesFrame creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    GetSizer()->Fit(this);
    GetSizer()->SetSizeHints(this);
    Centre();
////@end WinEDA_LabelPropertiesFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_LabelPropertiesFrame
 */

void WinEDA_LabelPropertiesFrame::CreateControls()
{    
	SetFont(*g_DialogFont);
////@begin WinEDA_LabelPropertiesFrame content construction
    // Generated by DialogBlocks, 07/11/2007 12:37:47 (unregistered)

    WinEDA_LabelPropertiesFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText4 = new wxStaticText( itemDialog1, wxID_STATIC, _("Text "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText4, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextLabel = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxSize(250, -1), 0 );
    itemBoxSizer3->Add(m_TextLabel, 0, wxGROW|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxBoxSizer* itemBoxSizer6 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer3->Add(itemBoxSizer6, 0, wxGROW|wxALL, 5);

    wxArrayString m_TextOrientStrings;
    m_TextOrientStrings.Add(_("Right"));
    m_TextOrientStrings.Add(_("Up"));
    m_TextOrientStrings.Add(_("Left"));
    m_TextOrientStrings.Add(_("Down"));
    m_TextOrient = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Text Orient:"), wxDefaultPosition, wxDefaultSize, m_TextOrientStrings, 1, wxRA_SPECIFY_COLS );
    m_TextOrient->SetSelection(0);
    itemBoxSizer6->Add(m_TextOrient, 0, wxALIGN_TOP|wxALL, 5);

    itemBoxSizer6->Add(5, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxArrayString m_TextShapeStrings;
    m_TextShapeStrings.Add(_("Input"));
    m_TextShapeStrings.Add(_("Output"));
    m_TextShapeStrings.Add(_("Bidi"));
    m_TextShapeStrings.Add(_("TriState"));
    m_TextShapeStrings.Add(_("Passive"));
    m_TextShape = new wxRadioBox( itemDialog1, ID_RADIOBOX1, _("Glabel Shape:"), wxDefaultPosition, wxDefaultSize, m_TextShapeStrings, 1, wxRA_SPECIFY_COLS );
    m_TextShape->SetSelection(0);
    m_TextShape->Show(false);
    itemBoxSizer6->Add(m_TextShape, 0, wxALIGN_TOP|wxALL, 5);

    wxBoxSizer* itemBoxSizer10 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer10, 0, wxGROW|wxALL, 5);

    m_SizeTitle = new wxStaticText( itemDialog1, wxID_STATIC, _("Size "), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer10->Add(m_SizeTitle, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_TextSize = new wxTextCtrl( itemDialog1, ID_TEXTCTRL1, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer10->Add(m_TextSize, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    itemBoxSizer10->Add(5, 5, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxButton* itemButton14 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton14->SetDefault();
    itemButton14->SetForegroundColour(wxColour(204, 0, 0));
    itemBoxSizer10->Add(itemButton14, 0, wxGROW|wxALL, 5);

    wxButton* itemButton15 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton15->SetForegroundColour(wxColour(0, 0, 255));
    itemBoxSizer10->Add(itemButton15, 0, wxGROW|wxALL, 5);

    // Set validators
    m_TextOrient->SetValidator( wxGenericValidator(& m_CurrentText->m_Orient) );
    m_TextShape->SetValidator( wxGenericValidator(& m_CurrentText->m_Shape) );
////@end WinEDA_LabelPropertiesFrame content construction

    if (m_CurrentText->Type() == DRAW_GLOBAL_LABEL_STRUCT_TYPE )
        m_TextShape->Show(true);
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_LabelPropertiesFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_LabelPropertiesFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_LabelPropertiesFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_LabelPropertiesFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_LabelPropertiesFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_LabelPropertiesFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_LabelPropertiesFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_LabelPropertiesFrame::OnOkClick( wxCommandEvent& event )
{
   TextPropertiesAccept(event);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_LabelPropertiesFrame::OnCancelClick( wxCommandEvent& event )
{
    m_Parent->DrawPanel->MouseToCursorSchema();
    EndModal( -1 );
}
