/////////////////////////////////////////////////////////////////////////////
// Name:        plotdxf.cpp
// Purpose:
// Author:      Lorenzo Marcantonio
// Modified by:
// Created:     01/02/2006 08:37:24
// RCS-ID:
// Copyright:   GNU License
// Licence:
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 01/02/2006 08:37:24

#if defined(__GNUG__) && !defined(NO_GCC_PRAGMA)
#pragma implementation "plotdxf.h"
#endif

#include "fctsys.h"
#include "gr_basic.h"
#include "common.h"
#include "plot_common.h"
#include "confirm.h"
#include "worksheet.h"

#include "program.h"
#include "general.h"
#include "protos.h"


static bool Plot_Sheet_Ref = TRUE;

#include "plotdxf.h"

////@begin XPM images
////@end XPM images


void WinEDA_SchematicFrame::ToPlot_DXF( wxCommandEvent& event )
{
    wxPoint pos;

    pos = GetPosition();

    pos.x += 10;
    pos.y += 20;

    WinEDA_PlotDXFFrame* DXF_frame = new WinEDA_PlotDXFFrame( this );

    DXF_frame->ShowModal();
    DXF_frame->Destroy();
}


/*!
 * WinEDA_PlotDXFFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_PlotDXFFrame, wxDialog )

/*!
 * WinEDA_PlotDXFFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_PlotDXFFrame, wxDialog )

////@begin WinEDA_PlotDXFFrame event table entries
    EVT_BUTTON( ID_PLOT_DXF_CURRENT_EXECUTE,
                WinEDA_PlotDXFFrame::OnPlotDXFCurrentExecuteClick )

    EVT_BUTTON( ID_PLOT_DXF_ALL_EXECUTE,
                WinEDA_PlotDXFFrame::OnPlotDXFAllExecuteClick )

    EVT_BUTTON( wxID_CANCEL, WinEDA_PlotDXFFrame::OnCancelClick )

////@end WinEDA_PlotDXFFrame event table entries

END_EVENT_TABLE()
/*!
 * WinEDA_PlotDXFFrame constructors
 */

WinEDA_PlotDXFFrame::WinEDA_PlotDXFFrame()
{
}


WinEDA_PlotDXFFrame::WinEDA_PlotDXFFrame( WinEDA_DrawFrame* parent,
                                          wxWindowID        id,
                                          const wxString&   caption,
                                          const wxPoint&    pos,
                                          const wxSize&     size,
                                          long              style )
{
    m_Parent = parent;
    PlotDXFColorOpt = false;
    Create( parent, id, caption, pos, size, style );
}


/*!
 * WinEDA_PlotDXFFrame creator
 */

bool WinEDA_PlotDXFFrame::Create( wxWindow*       parent,
                                  wxWindowID      id,
                                  const wxString& caption,
                                  const wxPoint&  pos,
                                  const wxSize&   size,
                                  long            style )
{
////@begin WinEDA_PlotDXFFrame member initialisation
    m_PlotDXFColorOption = NULL;
    m_Plot_Sheet_Ref     = NULL;
    m_btClose = NULL;
    m_MsgBox  = NULL;

////@end WinEDA_PlotDXFFrame member initialisation

////@begin WinEDA_PlotDXFFrame creation
    SetExtraStyle( wxWS_EX_BLOCK_EVENTS );
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if( GetSizer() )
    {
        GetSizer()->SetSizeHints( this );
    }
    Centre();

////@end WinEDA_PlotDXFFrame creation
    return true;
}


/*!
 * Control creation for WinEDA_PlotDXFFrame
 */

void WinEDA_PlotDXFFrame::CreateControls()
{
////@begin WinEDA_PlotDXFFrame content construction
    // Generated by DialogBlocks, 24/04/2009 14:25:24 (unregistered)

    WinEDA_PlotDXFFrame* itemDialog1 = this;

    wxBoxSizer*          itemBoxSizer2 = new wxBoxSizer( wxVERTICAL );

    itemDialog1->SetSizer( itemBoxSizer2 );

    wxBoxSizer*       itemBoxSizer3 = new wxBoxSizer( wxHORIZONTAL );
    itemBoxSizer2->Add( itemBoxSizer3, 0, wxALIGN_CENTER_HORIZONTAL | wxALL, 5 );

    wxStaticBox*      itemStaticBoxSizer6Static =
        new wxStaticBox( itemDialog1, wxID_ANY, _( "Plot Options:" ) );
    wxStaticBoxSizer* itemStaticBoxSizer6 =
        new wxStaticBoxSizer( itemStaticBoxSizer6Static, wxVERTICAL );
    itemBoxSizer3->Add( itemStaticBoxSizer6,
                        0,
                        wxALIGN_CENTER_VERTICAL | wxALL,
                        5 );

    wxArrayString m_PlotDXFColorOptionStrings;
    m_PlotDXFColorOptionStrings.Add( _( "B/W" ) );
    m_PlotDXFColorOptionStrings.Add( _( "Color" ) );
    m_PlotDXFColorOption =
        new wxRadioBox( itemDialog1, ID_RADIOBOX, _( "Plot Color:" ),
                        wxDefaultPosition, wxDefaultSize,
                        m_PlotDXFColorOptionStrings, 1, wxRA_SPECIFY_COLS );
    m_PlotDXFColorOption->SetSelection( 0 );
    itemStaticBoxSizer6->Add( m_PlotDXFColorOption, 0, wxGROW | wxALL, 5 );

    m_Plot_Sheet_Ref =
        new wxCheckBox( itemDialog1, ID_CHECKBOX, _( "Print Sheet Ref" ),
                        wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_Plot_Sheet_Ref->SetValue( false );
    itemStaticBoxSizer6->Add( m_Plot_Sheet_Ref, 0, wxGROW | wxALL, 5 );

    itemBoxSizer3->Add( 5, 5, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5 );

    wxBoxSizer* itemBoxSizer10 = new wxBoxSizer( wxVERTICAL );
    itemBoxSizer3->Add( itemBoxSizer10, 0, wxALIGN_CENTER_VERTICAL | wxALL, 5 );

    wxButton*   itemButton11 = new wxButton( itemDialog1,
                                             ID_PLOT_DXF_CURRENT_EXECUTE,
                                             _( "&Plot Page" ),
                                             wxDefaultPosition,
                                             wxDefaultSize,
                                             0 );
    itemButton11->SetDefault();
    itemBoxSizer10->Add( itemButton11, 0, wxGROW | wxALL, 5 );

    wxButton* itemButton12 = new wxButton( itemDialog1,
                                           ID_PLOT_DXF_ALL_EXECUTE,
                                           _( "Plot A&LL" ),
                                           wxDefaultPosition,
                                           wxDefaultSize,
                                           0 );
    itemBoxSizer10->Add( itemButton12, 0, wxGROW | wxALL, 5 );

    m_btClose = new wxButton( itemDialog1, wxID_CANCEL, _( "Close" ),
                              wxDefaultPosition, wxDefaultSize,
                              0 );
    itemBoxSizer10->Add( m_btClose, 0, wxGROW | wxALL, 5 );

    wxStaticText* itemStaticText15 = new wxStaticText( itemDialog1,
                                                       wxID_STATIC,
                                                       _( "Messages :" ),
                                                       wxDefaultPosition,
                                                       wxDefaultSize,
                                                       0 );
    itemBoxSizer2->Add( itemStaticText15,
                        0,
                        wxALIGN_LEFT | wxLEFT | wxRIGHT | wxTOP |
                        wxADJUST_MINSIZE,
                        5 );

    m_MsgBox = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T( "" ),
                               wxDefaultPosition, wxSize( -1, 200 ),
                               wxTE_MULTILINE );
    itemBoxSizer2->Add( m_MsgBox, 0, wxGROW | wxALL | wxFIXED_MINSIZE, 5 );

    // Set validators
    m_PlotDXFColorOption->SetValidator( wxGenericValidator( &PlotDXFColorOpt ) );
    m_Plot_Sheet_Ref->SetValidator( wxGenericValidator( &Plot_Sheet_Ref ) );

////@end WinEDA_PlotDXFFrame content construction

    SetFocus(); // make the ESC work
}


/*!
 * Should we show tooltips?
 */

bool WinEDA_PlotDXFFrame::ShowToolTips()
{
    return true;
}


/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_PlotDXFFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_PlotDXFFrame bitmap retrieval
    wxUnusedVar( name );
    return wxNullBitmap;

////@end WinEDA_PlotDXFFrame bitmap retrieval
}


/*!
 * Get icon resources
 */

wxIcon WinEDA_PlotDXFFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_PlotDXFFrame icon retrieval
    wxUnusedVar( name );
    return wxNullIcon;

////@end WinEDA_PlotDXFFrame icon retrieval
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON
 */

void WinEDA_PlotDXFFrame::OnPlotDXFCurrentExecuteClick( wxCommandEvent& event )
{
    int Select_PlotAll = FALSE;

    InitOptVars();
    CreateDXFFile( Select_PlotAll );
    m_MsgBox->AppendText( wxT( "*****\n" ) );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for ID_BUTTON1
 */

void WinEDA_PlotDXFFrame::OnPlotDXFAllExecuteClick( wxCommandEvent& event )
{
    int Select_PlotAll = TRUE;

    InitOptVars();
    CreateDXFFile( Select_PlotAll );
    m_MsgBox->AppendText( wxT( "*****\n" ) );
}


/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_PlotDXFFrame::OnCancelClick( wxCommandEvent& event )
{
    InitOptVars();
    EndModal( 0 );
}


void WinEDA_PlotDXFFrame::InitOptVars()
{
    Plot_Sheet_Ref  = m_Plot_Sheet_Ref->GetValue();
    PlotDXFColorOpt = m_PlotDXFColorOption->GetSelection();
}


void WinEDA_PlotDXFFrame::CreateDXFFile( int AllPages )
{
    WinEDA_SchematicFrame* schframe  = (WinEDA_SchematicFrame*) m_Parent;
    SCH_SCREEN*            screen    = schframe->GetScreen();
    SCH_SCREEN*            oldscreen = screen;
    SCH_SHEET_PATH*        sheetpath, * oldsheetpath = schframe->GetSheet();
    wxString               PlotFileName;
    Ki_PageDescr*          PlotSheet;
    wxPoint                plot_offset;

    /* When printing all pages, the printed page is not the current page.
     *  In complex hierarchies, we must setup references and others parameters
     * in the printed SCH_SCREEN
     *  because in complex hierarchies a SCH_SCREEN (a schematic drawings)
     *  is shared between many sheets
     */
    SCH_SHEET_LIST SheetList( NULL );

    sheetpath = SheetList.GetFirst();
    SCH_SHEET_PATH list;

    while( true )
    {
        if( AllPages )
        {
            if( sheetpath == NULL )
                break;
            list.Clear();
            if( list.BuildSheetPathInfoFromSheetPathValue( sheetpath->Path() ) )
            {
                schframe->m_CurrentSheet = &list;
                schframe->m_CurrentSheet->UpdateAllScreenReferences();
                schframe->SetSheetNumberAndCount();
                screen = schframe->m_CurrentSheet->LastScreen();
                ActiveScreen = screen;
            }
            else  // Should not happen
                return;
            sheetpath = SheetList.GetNext();
        }
        PlotSheet = screen->m_CurrentSheetDesc;
        double scale = 10;

        plot_offset.x = 0;
        plot_offset.y = 0;

        PlotFileName = schframe->GetUniqueFilenameForCurrentSheet() + wxT(
            ".dxf" );

        PlotOneSheetDXF( PlotFileName, screen, PlotSheet, plot_offset, scale );

        if( !AllPages )
            break;
    }

    ActiveScreen = oldscreen;
    schframe->m_CurrentSheet = oldsheetpath;
    schframe->m_CurrentSheet->UpdateAllScreenReferences();
    schframe->SetSheetNumberAndCount();
}


void WinEDA_PlotDXFFrame::PlotOneSheetDXF( const wxString& FileName,
                                           SCH_SCREEN*     screen,
                                           Ki_PageDescr*   sheet,
                                           wxPoint         plot_offset,
                                           double          scale )
{
    wxString msg;

    FILE*    output_file = wxFopen( FileName, wxT( "wt" ) );

    if( output_file == NULL )
    {
        msg  = wxT( "\n** " );
        msg += _( "Unable to create " ) + FileName + wxT( " **\n\n" );
        m_MsgBox->AppendText( msg );
        wxBell();
        return;
    }

    SetLocaleTo_C_standard();
    msg.Printf( _( "Plot: %s\n" ), FileName.GetData() );
    m_MsgBox->AppendText( msg );

    DXF_PLOTTER* plotter = new DXF_PLOTTER();
    plotter->set_paper_size( sheet );
    plotter->set_viewport( plot_offset, scale, 0 );
    plotter->set_color_mode( PlotDXFColorOpt );

    /* Init : */
    plotter->set_creator( wxT( "EESchema-DXF" ) );
    plotter->set_filename( FileName );
    plotter->start_plot( output_file );

    if( Plot_Sheet_Ref )
    {
        plotter->set_color( BLACK );
        m_Parent->PlotWorkSheet( plotter, screen );
    }

    PlotDrawlist( plotter, screen->EEDrawList );

    /* fin */
    plotter->end_plot();
    delete plotter;
    SetLocaleTo_Default();

    m_MsgBox->AppendText( wxT( "Ok\n" ) );
}
