; $Id: kildclient.iss,v 1.12 2006/08/12 20:35:23 ekalin Exp $
;
; Inno Setup script to generate KildClient installer.
; When generating the installer for a new version, the following must be
; changed/verified:
;   - Version number in #define section
;   - New files included in the package
;   - GTK+ version necessary, and version of GTK+ Runtime included
;   - Make sure to run strip on the .exe before compiling!
;   - Generate html docs

; When INCLUDE_GTK is defined, the installer includes the GTK+ Runtime
; installer and runs it, so that everything is installed automatically.
#define INCLUDE_GTK

; Some defines
#define AppName "KildClient"
#define AppId   "KildClient"
#define AppVer  "2.5.0"
#define URL     "http://kildclient.sf.net"

[Setup]
AppId={#AppId}
AppName={#AppName}
AppVersion={#AppVer}
AppVerName={#AppName} {#AppVer}
AppPublisher=Eduardo M Kalinowski
AppPublisherURL={#URL}
AppSupportURL={#URL}
AppUpdatesURL={#URL}
DefaultDirName={pf}\KildClient
DefaultGroupName=KildClient
AllowNoIcons=true
LicenseFile=J:\progs\kildclient-win32\COPYING
OutputDir=J:\progs\kildclient-win32\win32
#ifdef INCLUDE_GTK
OutputBaseFilename=kildclient-{#AppVer}
#else
OutputBaseFilename=kildclient-{#AppVer}-nogtk
#endif
Compression=lzma
SolidCompression=true
AppCopyright=This program is released under the GNU General Public License
ShowLanguageDialog=yes
RestartIfNeededByRun=yes

[Languages]
Name: eng; MessagesFile: compiler:Default.isl
Name: bra; MessagesFile: compiler:Languages\BrazilianPortuguese.isl

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked

[Files]
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
Source: J:\progs\kildclient-win32\src\kildclient.exe; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\src\wndmain.glade; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\src\kildclient.glade; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\NEWS; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\COPYING; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\share\kildclient.hlp; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\share\kildclient.pl; DestDir: {app}; Flags: ignoreversion
Source: J:\progs\kildclient-win32\po\pt_BR.mo; DestDir: {app}\locale\pt_BR\LC_MESSAGES; DestName: kildclient.mo; Tasks: ; Languages: ; Flags: ignoreversion
Source: J:\progs\kildclient-win32\po\eo.mo; DestDir: {app}\locale\eo\LC_MESSAGES; DestName: kildclient.mo; Tasks: ; Languages: ; Flags: ignoreversion
Source: J:\progs\kildclient-win32\win32\gettext.pm; DestDir: {app}\Locale; DestName: Gettext.pm; Flags: ignoreversion
Source: J:\progs\kildclient-win32\share\plugins\*.pl; DestDir: {app}\plugins; Flags: ignoreversion
Source: J:\progs\kildclient-win32\doc\C\kildclient\*.html; DestDir: {app}\manual\html; Flags: ignoreversion
Source: J:\progs\kildclient-win32\doc\C\images\*.png; DestDir: {app}\manual\html\images; Flags: ignoreversion
;Source: J:\progs\kildclient-win32\doc\C\kildclient.pdf; DestDir: {app}\manual; Flags: ignoreversion
Source: C:\MinGW\bin\libregex.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\GTK\bin\libxml2.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\GTK\bin\libglade-2.0-0.dll; DestDir: {app}; Flags: ignoreversion
;Source: C:\MinGW\bin\aspell-15.dll; DestDir: {app}; Flags: ignoreversion
;Source: C:\MinGW\bin\libgtkspell.dll; DestDir: {app}; Flags: ignoreversion
#ifdef INCLUDE_GTK
Source: J:\downloads\cross-tools\runtime\gtk+-runtime.exe; DestDir: {tmp}
#endif

[INI]
Filename: {app}\kildclient.url; Section: InternetShortcut; Key: URL; String: http://kildclient.sf.net
Filename: {app}\manual.url; Section: InternetShortcut; Key: URL; String: {app}\manual\html\index.html

[Icons]
Name: {group}\KildClient; Filename: {app}\kildclient.exe
Name: {group}\{cm:Manual}; Filename: {app}\manual.url
Name: {group}\{cm:ProgramOnTheWeb,KildClient}; Filename: {app}\kildclient.url
Name: {group}\{cm:UninstallProgram,KildClient}; Filename: {uninstallexe}
Name: {userdesktop}\KildClient; Filename: {app}\kildclient.exe; Tasks: desktopicon

[Run]
#ifdef INCLUDE_GTK
Filename: {tmp}\gtk+-runtime.exe; Parameters: "/DIR=""{code:GetInstallGTKDir}"" /SP- /SILENT"; StatusMsg: "Installing GTK+ Runtime"; Check: NeedToInstallGtk; Flags: hidewizard
#endif
Filename: {app}\kildclient.exe; Description: {cm:LaunchProgram,KildClient}; Flags: nowait postinstall skipifsilent

[UninstallDelete]
Type: files; Name: {app}\kildclient.url
Type: files; Name: {app}\manual.url

[CustomMessages]
eng.Manual=Manual
bra.Manual=Manual

[Code]
const
  // Required GTK+ Version
  MAJORGTKREQUIRED = 2; MINORGTKREQUIRED = 8;
  // Version of GTK+ Runtime included in this setup
  MAJORGTKINCLUDED = 2; MINORGTKINCLUDED = 8; BUGFIXGTKINCLUDED = 18;


#ifdef INCLUDE_GTK
var
  pageGTKDir: TInputDirWizardPage;
#endif


function GetGtkVersion(var Major, Minor, Bugfix: Longint): Boolean;
{ Tries to get the version of the GTK+ runtime that is installed.
  If GTK+ is found, returns True and sets Major and Minor. If
  GTK+ is not installed, returns False. }
var
  GTKVer: String;
  MajorStr, MinorStr, BugfixStr: String;
  Dot: Integer;
begin
  if RegQueryStringValue(HKEY_LOCAL_MACHINE, 'Software\GTK\2.0\', 'Version', GTKVer) then
  begin
    { Get Major and Minor version numbers as strings }
    Dot := Pos('.', GTKVer);
    MajorStr := Copy(GTKVer, 1, Dot - 1);
    Delete(GTKVer, 1, Dot);
    Dot := Pos('.', GTKVer);
    MinorStr := Copy(GTKVer, 1, Dot - 1);
    Delete(GTKVer, 1, Dot);
    Dot := Pos('-', GTKVer);
    BugfixStr := Copy(GTKVer, 1, Dot - 1);

    { Convert them to Integers }
    Major  := StrToIntDef(MajorStr,  0);
    Minor  := StrToIntDef(MinorStr,  0);
    Bugfix := StrToIntDef(BugfixStr, 0);

    Result := True;
  end
  else
  begin
    Result := False;
  end;
end;


#ifdef INCLUDE_GTK
function NeedToInstallGtk(): Boolean;
{ Verifies the version of GTK+ currently installed, if there is any.
  If GTK+ is installed and the installed version is newer or equal than
  the one included, the runtime is not installed. }
var
  Major, Minor, Bugfix: Longint;
begin
  if GetGTKVersion(Major, Minor, Bugfix) then
  begin
    if (Major > MAJORGTKINCLUDED)
      or ((Major = MAJORGTKINCLUDED) and (Minor > MINORGTKINCLUDED))
      or ((Major = MAJORGTKINCLUDED) and (Minor = MINORGTKINCLUDED) and (Bugfix >= BUGFIXGTKINCLUDED)) then
    begin
      Result := False
    end
    else
    begin
      Result := True;
    end;
  end
  else
  begin
    Result := True;
  end;
end;


procedure InitializeWizard();
{ Adds a page for the user to select the directory to install GTK+ in. }
var
  Path: String;
begin
  if NeedToInstallGtk() then
  begin
    pageGTKDir := CreateInputDirPage(wpUserInfo,
                                     'GTK+ Installation',
                                     'Select where the GTK+ Runtime files will be installed.',
                                     'The GTK+ Runtime files will be installed in the folder you specify here.' #13#10
                                     'To continue, click Next.',
                                     True, 'GTK\2.0');
    pageGTKDir.add('');
    // Set default value
    if RegQueryStringValue(HKEY_LOCAL_MACHINE, 'Software\GTK\2.0\', 'Path', Path) then
    begin
      pageGTKDir.Values[0] := Path;
    end
    else
    begin
      pageGTKDir.Values[0] := ExpandConstant('{cf}\GTK\2.0');
    end;
  end;
end;


function GetInstallGTKDir(Param: String): String;
begin
  Result := pageGTKDir.Values[0];
end;
#endif


#ifndef INCLUDE_GTK
function InitializeSetup(): Boolean;
{ Aborts installation if the correct GTK+ Runtime is not installed. }
var
  Major, Minor, Bugfix: Longint;
begin
  if GetGTKVersion(Major, Minor, Bugfix) then
  begin
    if (Major < MAJORGTKINCLUDED)
       or ((Major = MAJORGTKINCLUDED) and (Minor < MINORGTKINCLUDED)) then
    begin
      MsgBox('Incorrect GTK+ version.' #13#10
             'This program requires GTK+ version 2.8.X or greater.',
             mbError, MB_OK);
      Result := False;
    end
    else
    begin
      Result := True;
    end;
  end
  else
  begin
    MsgBox('Could not find the GTK+ Runtime.' #13#10
           'This program requires GTK+ version 2.8.X. or greater.' #13#10
           'You must intall the GTK+ Runtime before installing KildClient.',
           mbError, MB_OK);
    Result := False;
  end;
end;
#endif


procedure CurStepChanged(CurStep: TSetupStep);
var
  UninstallPath: String;
  UninstallString: String;
  ResultCode: Integer;
begin
  { Uninstall a previous version (if it is found) }
  if (CurStep = ssInstall) then
  begin
    UninstallPath   := 'Software\Microsoft\Windows\CurrentVersion\Uninstall\{#AppId}_is1';
    UninstallString := '';
    if RegQueryStringValue(HKLM, UninstallPath, 'UninstallString', UninstallString) then
    begin
      if UninstallString <> '' then
      begin
        UninstallString := RemoveQuotes(UninstallString);
        Exec(UninstallString, '/SILENT /NORESTART /SUPPRESSMSGBOXES', '',
             SW_HIDE, ewWaitUntilTerminated, ResultCode);
      end;
    end;
  end;
end;
