/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
 *
 * Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
 *         Xudong Tang       <tang@MissionCriticalLinux.Com>
 *
 * svcmgr.h
 * $Revision: 1.21 $
 */
 
/*
 * Function return status
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define FAIL			-1
#define WARNING                 -2
#define TRY_MORE                -3   
#define SUCCESS			0
#define YES			2
#define NO			3   
#define TIMEOUT			4
#define NOT_FOUND		5

#define CONSOLE			/dev/console

#define SHUTDOWN_CMD		"/sbin/shutdown"

#define DEFAULT_LOGLEVEL	LOG_NOTICE

#define MAX_LINELEN		2048
#define MAX_ERROR_BUFLEN	2048	// error buffer length

/*
 * How long should we wait for things .... forever?
 */
#define DAEMON_SLEEP_TIME	5	// secs to wait for other daemons
#define SVC_SLEEP_TIME		1	// secs to wait on service state changes
#define SVC_SLEEP_INCREMENT	1	// time between sleeping
#define SVC_MAX_SLEEP_TIME	1800	// total time (secs) to wait for svc
#define MSG_TIMEOUT_INIT	1	// trying to connect to quorumd
#define MSG_TIMEOUT_NORMAL	10	// normal secs timeout for msg_receive

/*
 * Cluster database
 */
#define DB_INIT_SIZE		102400	// size of cluster database
#define MIN_TOKEN_ID		0	// first token ID
#define MAX_TOKEN_LEN		2048	// max length of a token string
#define MAX_INTERFACE           50      // lo,eth0,etc. The # of interfaces   
#define MAX_LINE_LEN            100

/*
 * Service owners
 */
#define SVC_OWNER_NOBODY	-1

/*
 * Service IDs
 */
#define SVC_ID_NONE		-1

/*
 * Service actions
 */
#define SVC_START		0
#define SVC_STOP		1
#define SVC_DISABLE		2
#define SVC_WAITANDSTART	3
#define SVC_WAITANDSTOP		4
#define SVC_DONOTHING		5

char errbuf[128];


/*
 * Service database entry strings.  These are the strings that are entered
 * in the service database to describe the service.  Some of these entries
 * are labels where the real values are in sub-sections.  Refer to the
 * service database description file for more information.
 */
#define SVC_SERVICES_LIST_STR		"services"
#define SVC_SERVICE_STR			"service"
#define SVC_NAME_STR 			"name"
#define SVC_DISABLED_STR		"disabled"
#define SVC_PREFERRED_NODE_STR		"preferredNode"
#define SVC_RELOCATE_ON_BOOT_STR	"relocateOnPreferredNodeBoot"
#define SVC_USER_SCRIPT_STR		"userScript"
#define SVC_NETWORK_STR			"network"
#define SVC_IP_ADDR_STR			"ipAddress"
#define SVC_NETMASK_STR			"netmask"
#define SVC_BROADCAST_STR		"broadcast"
#define SVC_DEVICE_STR			"device"
#define SVC_DEVICE_NAME_STR		"name"
#define SVC_MOUNT_STR			"mount"
#define SVC_MOUNT_NAME_STR		"name"
#define SVC_MOUNT_OPTIONS_STR		"options"
#define SVC_MOUNT_FSTYPE_STR            "fstype"
#define SVC_FORCE_UNMOUNT_STR		"forceUnmount"
#define SVC_NFS_STR			"NFS"
#define SVC_NFS_SVR_DIR_STR		"serverDir"
#define SVC_NFS_SVR_DEV_STR		"serverDev"
#define SVC_EXPORT_STR			"NFSexports"
#define SVC_EXPORT_DIR_STR		"directory"
#define SVC_EXPORT_NAME_STR		"name"
#define SVC_EXPORT_CLIENT_STR		"client"
#define SVC_EXPORT_CLIENT_NAME_STR	"name"
#define SVC_EXPORT_CLIENT_OPTIONS_STR	"options" 
#define SVC_DEVICE_OWNER_STR		"owner"
#define SVC_DEVICE_GROUP_STR		"group"
#define SVC_DEVICE_MODE_STR		"mode"

/*
 * Node database entry strings.
 */
#define NODE_LIST_STR			"members"
#define NODE_STR			"member"
#define NODE_ID_STR			"id"
#define NODE_NAME_STR			"name"

/*
 * Service Manager database entry strings
 */
#define SVCMGR_STR			"svcmgr"
#define SVCMGR_LOGLEVEL_STR		"logLevel"
#define SVCMGR_SVC_STOP_FAIL_STR	"svcStopFailureAction"	// not used
#define SVCMGR_EXIT_FAIL_STR		"exitFailureAction"	// not used

/*
 * Possible values for entries in the service section of the database
 */
#define YES_STR				"yes"
#define NO_STR				"no"

/*
 * Service Manager prototypes
 */

/* svc.c */
int lockAndReqServiceStatus(int svcID, ServiceBlock *svcStatusPtr);
int lockAndReqServiceStatusChange(ServiceBlock *svcStatusPtr);
int reqServiceStatus(int svcID, ServiceBlock *svcStatusPtr);
int reqServiceStatusChange(ServiceBlock *svcStatusPtr);
int initServiceStatus(int svcID, char *errMsg);
int isServiceStateDisabled(int svcID, char *errMsg);
int reqEnableService(int svcID, char *errMsg);
int reqDisableService(int svcID, char *errMsg);
int addService(int svcID, char *errMsg);
int deleteService(int svcID, char *errMsg);
int startService(int svcID);
int stopService(int svcID);
int disableService(int svcID);
int closeChildFDs(void);

/* svc_db.c */
int getDatabaseToken(char *token, char **value);
int setDatabaseToken(char *token, char *value);
int findNextFreeEntry(char *tokenPath, int *freeEntry);

int getSvcNameTokenStr(int svcID, char *tokenStr);
int getSvcScriptTokenStr(int svcID, char *tokenStr);
int getSvcRelocateOnPreferredNodeBootTokenStr(int svcID, char *tokenStr);
int getSvcPreferredNodeNameTokenStr(int svcID, char *tokenStr);
int getSvcDisabledTokenStr(int svcID, char *tokenStr);
int getSvcIPaddressTokenStr(int svcID, int N, char *tokenStr);
int getSvcNetmaskTokenStr(int svcID, int N, char *tokenStr);
int getSvcBroadcastTokenStr(int svcID, int N, char *tokenStr);
int getSvcDeviceTokenStr(int svcID, int N, char *tokenStr);
int getSvcMountPointTokenStr(int svcID, int N, char *tokenStr);
int getSvcMountOptionsTokenStr(int svcID, int N, char *tokenStr);
int getSvcMountFstypeTokenStr(int svcID, int N, char *tokenStr);
int getSvcForceUnmountTokenStr(int svcID, int N, char *tokenStr);
int getSvcDeviceOwnerTokenStr(int svcID, int N, char *tokenStr);
int getSvcDeviceGroupTokenStr(int svcID, int N, char *tokenStr);
int getSvcDeviceModeTokenStr(int svcID, int N, char *tokenStr);

int getSvcID(char *svcName, int *svcID);
int getSvcName(int svcID, char **svcName);
int getSvcScript(int svcID, char **svcScript);
int getSvcRelocateOnPreferredNodeBoot(int svcID, char **relocate);
int getSvcPreferredNodeName(int svcID, char **nodeName) ;
int getSvcPreferredNodeID(int svcID, int *nodeID);
int getSvcDisabled(int svcID, char **disabled);
int getSvcIPaddress(int svcID, int N, char **IPaddr);
int getSvcNetmask(int svcID, int N, char **netmask);
int getSvcBroadcast(int svcID, int N, char **broadcast);
int getSvcDevice(int svcID, int N, char **device);
int getSvcMountPoint(int svcID, int N, char **mountPoint);
int getSvcMountFstype(int svcID, int N, char **mountFstype);
int getSvcMountOptions(int svcID, int N, char **mountOptions);
int getSvcForceUnmount(int svcID, int N, char **forceUnmount);
int getSvcDeviceOwner(int svcID, int N, char **deviceOwner);
int getSvcDeviceGroup(int svcID, int N, char **deviceGroup);
int getSvcDeviceMode(int svcID, int N, char **deviceMode);

int ckSvcName(int current_svcID, char *svcName, char *errorMsg);
int ckSvcScript(char *svcScript, char *errorMsg);
int ckSvcRelocateOnPreferredNodeBoot(char *relocate, char *errorMsg);
int ckSvcPreferredNodeName( char *nodeName, char *errorMsg);
int ckSvcPreferredNodeID( int nodeID, char *errorMsg);
int ckSvcDisabled(char *disabled, char *errorMsg);
int ckSvcIPaddress(int current_svcID, int current_ipN, char *IPaddr,char *errorMsg);
int ckSvcBroadcast(char *Broadcast, char *errorMsg);
int ckSvcNetmask(char *Netmask, char *errorMsg);
int ckSvcDevice(int current_svcID, int current_devN, char *device, char *errorMsg);
int ckSvcMountPoint(int current_svcID, int current_devN, char *mountPoint, char *errorMsg);
int ckSvcMountOptions(char *mountOptions, char *errorMsg);
int ckSvcMountFstype(char *mountFstype, char *errorMsg);
int ckSvcForceUnmount(char *forceUnmount, char *errorMsg);
int ckSvcDeviceOwner(char *deviceOwner, char *errorMsg);
int ckSvcDeviceGroup(char *deviceGroup, char *errorMsg);
int ckSvcDeviceMode(char *deviceMode, char *errorMsg);
int checkFormatOfIP(char *String, char *errorMsg);
int checkIsInDataset(char *data,char **dataset, char *errorMsg, int flag);
int ckIsMemberIP(char *IP, char *errMsg);

int setSvcName(int svcID, char *svcName, char *errMsg);
int setSvcScript(int svcID, char *svcScript, char *errMsg);
int setSvcRelocateOnPreferredNodeBoot(int svcID, char *relocate, char *errMsg);
int setSvcPreferredNodeName(int svcID, char *nodeName, char *errMsg);
int setSvcPreferredNodeID(int svcID, int nodeID, char *errMsg);
int setSvcDisabled(int svcID, char *disabled, char *errMsg);
int setSvcIPaddress(int svcID, int N, char *IPaddr, char *errMsg);
int setSvcNetmask(int svcID, int N, char *netmask, char *errMsg);
int setSvcBroadcast(int svcID, int N, char *broadcast, char *errMsg);
int setSvcDevice(int svcID, int N, char *device, char *errMsg);
int setSvcMountPoint(int svcID, int N, char *mountPoint, char *errMsg);
int setSvcMountFstype(int svcID, int N, char *mountFstype, char *errMsg);	
int setSvcMountOptions(int svcID, int N, char *mountOptions, char *errMsg);
int setSvcForceUnmount(int svcID, int N, char *forceUnmount, char *errMsg);
int setSvcDeviceOwner(int svcID, int N, char *deviceOwner, char *errMsg);
int setSvcDeviceGroup(int svcID, int N, char *deviceGroup, char *errMsg);
int setSvcDeviceMode(int svcID, int N, char *deviceMode, char *errMsg);

int getNextFreeSvcID(void);
int getNextFreeSvcIPaddress(int svcID, int *N);
int getNextFreeSvcDevice(int svcID, int *N);

int serviceExists(int svcID);
int isServiceDisabled(int svcID);
int doesServiceRelocateOnPreferredNodeBoot(int svcID);
int unmountsForcefully(int svcID, int N);
int reReadDatabase(char *database);
int getSvcMgrLogLevel(int *logLevel);
int getNodeName(int nodeID, char **nodeName);
int getNodeID(char *nodeName);

void clean_string(char *p, int flag);

#ifdef __cplusplus
}
#endif
