/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, http://www.stierand-linuxit.de   *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KINSTALLERPROCESS_H
#define KINSTALLERPROCESS_H


#include <qobject.h>
#include <qstring.h>

#include <kprocess.h>


/**
  */
class KInstallerProcess : public QObject
{
  Q_OBJECT
      
  public:
    KInstallerProcess(QObject *parent = 0, const char *name = 0);
    ~KInstallerProcess();
    bool exec(const QString & command, 
              const QString & arg1 = QString::null,
              const QString & arg2 = QString::null,
              const QString & arg3 = QString::null,
              const QString & arg4 = QString::null,
              const QString & arg5 = QString::null,
              const QString & arg6 = QString::null);
    bool isRunning();
    void requestAbort();
    
  signals:
    void signalProcessStdout(const QString & str);
    void signalProcessStderr(const QString & str);
    
  private slots: // Private slots
    /** process has send to stdout */
    void slotReceivedStdout(KProcess *proc, char *buf, int len);
    /** process has send to stdout */
    void slotReceivedStderr(KProcess *proc, char *buf, int len);
    /** process is at end */
    void slotProcessExited(KProcess *proc);
    
  private:
    KProcess * m_proc;
    bool m_aborted;
    bool m_result;
};

#endif
