/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, http://www.stierand-linuxit.de   *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KINSTALLERVIEW_H_
#define _KINSTALLERVIEW_H_

#include <qwidget.h>
//#include <kinstalleriface.h>

#include "kinstallervw.h"

#include "tinstallersettings.h"
#include "tpackageinfo.h"


//class QPainter;
//class KURL;

/**
 * This is the main view class for KInstaller.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 */
class KInstallerView : public KInstallerVw
{
  Q_OBJECT
      
  public:
    typedef enum {
      Ready,
      Install,
      InstallCanceled,
      Uninstall,
      UninstallCanceled
    } ViewState;
          
    /**
      * Default constructor
      */
    KInstallerView(QWidget *parent);

    /**
      * Destructor
      */
    virtual ~KInstallerView();

    void applySettings(TInstallerSettings * settings);
    
    /**
      * Returns the URL of the source package
      */
    QString sourceURL();
    void setSourceURL(const QString & url);

    /**
      * Returns the package info of the uninstall package
      */
    TPackageInfo * uninstallPackage();
    void setUninstallPackage(TPackageInfo * package);

    /**
      * Updates the package info list within the package table
      */
    bool updatePackageInfos(TPackageInfoList * infoList);
    
    TPackageInfo * selectedPackageInfo();
    
    /**
      * Toggles the state of the 'install' button.
      */
    ViewState viewState();
    void setViewState(ViewState state);
    
    void clearLogs();
    void appendInstallLog(const QString & text);
    void appendUninstallLog(const QString & text);
    
  signals:
    /**
     * Use this signal to change the content of the statusbar
     */
//    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
//    void signalChangeCaption(const QString& text);
    
    void signalSelectSourceClicked();
    
    void signalInstallClicked();
    void signalDeleteClicked();
    void signalUninstallClicked();

  private slots:
//    void slotOnURL(const QString& url);
//    void slotSetTitle(const QString& title);
    void slotSelectSourceClicked();
    
    void slotSelectedPackageChanged();
    
    void slotInstallClicked();
    void slotDeleteClicked();
    void slotUninstallClicked();
    
  private:
    ViewState m_viewState;
    TPackageInfo * m_selectedInfo;
};

#endif // _KINSTALLERVIEW_H_
