/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, http://www.stierand-linuxit.de   *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "pref.h"

#include <kiconloader.h>
#include <klocale.h>

#include <qvbox.h>
#include <qlayout.h>
#include <qlabel.h>


KInstallerPreferences::KInstallerPreferences()
    : KDialogBase(IconList, i18n("Preferences"),
                  Ok|Cancel, Ok)
//                  Help|Default|Ok|Apply|Cancel, Ok)
{
  KIconLoader iconLoader;
  
  
  // this is the base class for your preferences dialog.  it is now
  // a Treelist dialog.. but there are a number of other
  // possibilities (including Tab, Swallow, and just Plain)
  QVBox * b1;
  b1 = addVBoxPage(i18n("General"), i18n("General Preferences"),
                  iconLoader.loadIcon("misc", KIcon::NoGroup,KIcon::SizeMedium));
  m_pageOne = new KSettingsGeneralWidget(b1);

  QVBox * b2;
  b2 = addVBoxPage(i18n("Installation"), i18n("Installation Preferences"),
                   iconLoader.loadIcon("button_ok", KIcon::NoGroup,KIcon::SizeMedium));
  m_pageTwo = new KSettingsInstallWidget(b2);

  connect(m_pageOne, SIGNAL(signalGuessKDEBaseClicked(QString &)),
          this,   SLOT(slotGuessKDEBaseClicked(QString &)));
  connect(m_pageOne, SIGNAL(signalSelectStorageDirClicked(QString &)),
          this,   SLOT(slotSelectStorageDirClicked(QString &)));  
}


/*!
 */
bool KInstallerPreferences::execute(TInstallerSettings * settings)
{
  m_settings = settings;

  m_pageOne->setSettings(m_settings);
  m_pageTwo->setSettings(m_settings);

  if (exec())
  {
    m_pageOne->getSettings(m_settings);
    m_pageTwo->getSettings(m_settings);
    
    return(true);
  }
  else
  {
    return(false);
  }
}


/*!
 */
void KInstallerPreferences::slotGuessKDEBaseClicked(QString & dir)
{
  emit signalGuessKDEBaseClicked(dir);
}


/*!
 */
void KInstallerPreferences::slotSelectStorageDirClicked(QString & dir)
{
  emit signalSelectStorageDirClicked(dir);
}


#include "pref.moc"

