/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kconfig.h>

#include "tpackageinfo.h"


TPackageInfo::TPackageInfo()
{
}


TPackageInfo::~TPackageInfo()
{
}


QString TPackageInfo::filename()
{
  return(m_filename);
}



#define PKGINFO_GROUP           "KInstaller-package"
#define PKGINFO_KEY_DATETIME    "DateTime"
#define PKGINFO_KEY_FILE        "PackageFile"
#define PKGINFO_KEY_NAME        "PackageName"
#define PKGINFO_KEY_VERSION     "PackageVersion"
#define PKGINFO_KEY_RELEASE     "PackageRelease"
#define PKGINFO_KEY_INSTALLTYPE "InstallType"
#define PKGINFO_KEY_INSTALLDIR  "InstallDir"
#define PKGINFO_KEY_MAKEDIR     "MakeDir"


bool TPackageInfo::readInfo(QString filename)
{
  KConfig * config;

  config = new KConfig(filename);

  if (!config->hasGroup(PKGINFO_GROUP))
  {
    delete config;
    qDebug("no group");
    return(false);
  }
  
  config->setGroup(PKGINFO_GROUP);

  dateTime = config->readDateTimeEntry(PKGINFO_KEY_DATETIME,0);
  pkgFile = config->readEntry(PKGINFO_KEY_FILE,"");
  pkgName = config->readEntry(PKGINFO_KEY_NAME,"");
  pkgVersion = config->readEntry(PKGINFO_KEY_VERSION,"");
  pkgRelease = config->readEntry(PKGINFO_KEY_RELEASE,"");
  installType = config->readEntry(PKGINFO_KEY_INSTALLTYPE,"");
  installDir = config->readEntry(PKGINFO_KEY_INSTALLDIR,"");
  makeDir = config->readEntry(PKGINFO_KEY_MAKEDIR,"");

  qDebug("%s",pkgName.latin1());
  
  delete config;

  m_filename = filename;
  
  return(true);
}


bool TPackageInfo::writeInfo(QString filename)
{
  KConfig * config;

  config = new KConfig(filename);

  config->setGroup("KInstaller-package");

  config->writeEntry(PKGINFO_KEY_DATETIME,dateTime);
  config->writeEntry(PKGINFO_KEY_FILE,pkgFile);
  config->writeEntry(PKGINFO_KEY_NAME,pkgName);
  config->writeEntry(PKGINFO_KEY_VERSION,pkgVersion);
  config->writeEntry(PKGINFO_KEY_RELEASE,pkgRelease);
  config->writeEntry(PKGINFO_KEY_INSTALLTYPE,installType);
  config->writeEntry(PKGINFO_KEY_INSTALLDIR,installDir);
  config->writeEntry(PKGINFO_KEY_MAKEDIR,makeDir);
  
  config->sync();

  delete config;
  
  m_filename = filename;

  return(true);
}



TPackageInfoList::TPackageInfoList()
{
  m_infoList = new QPtrList<TPackageInfo>();
  m_infoList->setAutoDelete(true);
}


TPackageInfoList::~TPackageInfoList()
{
  delete m_infoList;
}


/*!
 */
uint TPackageInfoList::count()
{
  return(m_infoList->count());
}


/*!
 */
void TPackageInfoList::addInfo(TPackageInfo * info)
{
  m_infoList->append(info);
}


/*!
 */
bool TPackageInfoList::deleteInfo(TPackageInfo * info)
{
  return(m_infoList->remove(info));
}


/*!
 */
TPackageInfo * TPackageInfoList::infoAt(unsigned int index)
{
  return(m_infoList->at(index));
}


/*!
 */
TPackageInfo * TPackageInfoList::firstInfo()
{
  return(m_infoList->first());
}


/*!
 */
TPackageInfo * TPackageInfoList::nextInfo()
{
  return(m_infoList->next());
}
