/***************************************************************************
 *   Copyright (C) 2004 by Ingo Stierand, Stierand-LinuxIt                 *
 *   linuxit@web.de                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TPACKAGEINFO_H
#define TPACKAGEINFO_H

#include <qptrlist.h>
#include <qstring.h>
#include <qdatetime.h>


/**
  */
class TPackageInfo {
  public:
    TPackageInfo();
    ~TPackageInfo();

    QString filename();
    
    QDateTime dateTime;
    QString pkgFile;
    QString pkgName;
    QString pkgVersion;
    QString pkgRelease;
    QString installType;
    QString installDir;
    QString makeDir;
    
    /**
     * Reads the package information entry from file @e filename.
     */
    bool readInfo(QString filename);

    /**
     * Writes the package information entry to file @e filename.
     */
    bool writeInfo(QString filename);

  private:
    QString m_filename;
};


/**
 */
class TPackageInfoList {
  public:
    TPackageInfoList();
    ~TPackageInfoList();
    
    uint count();
    
    void addInfo(TPackageInfo * info);
    TPackageInfo * infoAt(unsigned int index);
    TPackageInfo * firstInfo();
    TPackageInfo * nextInfo();
    bool deleteInfo(TPackageInfo * info);

  private:
    QPtrList<TPackageInfo> * m_infoList;
};

#endif
