#ifndef KP_LOG_STORE_H_
#define KP_LOG_STORE_H_

#include <gtk/gtk.h>
#include "../kptraininglog.h"

#define KP_TYPE_LOG_STORE          (kp_log_store_get_type ())
#define KP_LOG_STORE(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), KP_TYPE_LOG_STORE, KPLogStore))
#define KP_LOG_STORE_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass),  KP_TYPE_LOG_STORE, KPLogStoreClass))
#define KP_IS_LOG_STORE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KP_TYPE_LOG_STORE))
#define KP_IS_LOG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  KP_TYPE_LOG_STORE))
#define KP_LOG_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  KP_TYPE_LOG_STORE, KPLogStoreClass))

/* The data columns that we export via the tree model interface */
enum
{
  KP_LOG_STORE_COL_RECORD = 0,
  KP_LOG_STORE_N_COLUMNS,
};

typedef enum
{
  KP_LOG_STORE_REC_ROOT,
  KP_LOG_STORE_REC_YEAR,
  KP_LOG_STORE_REC_MONTH,
  KP_LOG_STORE_REC_DAY,
  KP_LOG_STORE_REC_ENTRY,
  KP_LOG_STORE_REC_INVALID
} KPLogStoreRecordType;

typedef struct KPLogStoreRecord_
{
  guint d;
  guint m;
  guint y;

  gchar *record;

  guint n_entries;

  gboolean calendar_entry;
} KPLogStoreRecord;

typedef struct KPLogStore_
{
  GObject parent;

  GNode *root;

  gint n_columns;
  GType column_types[KP_LOG_STORE_N_COLUMNS];

  gint stamp;
} KPLogStore;

typedef struct KPLogStoreClass_
{
  GObjectClass parent_class;
} KPLogStoreClass;

GType                kp_log_store_get_type       (void);

KPLogStore          *kp_log_store_new            (void);

void                 kp_log_store_attach_log     (KPLogStore *store,
                                                  KPTrainingLog *log);

void                 kp_log_store_get_date       (KPLogStore *store,
                                                  GtkTreeIter *iter,
                                                  guint *d,
                                                  guint *m,
                                                  guint *y);
void                 kp_log_store_remove         (KPLogStore *store, 
                                                  GtkTreeIter *iter);
void                 kp_log_store_remove_mark    (KPLogStore *store,
                                                  guint d,
                                                  guint m,
                                                  guint y,
                                                  const gchar *mark);

void                 kp_log_store_add_mark       (KPLogStore *store,
                                                  guint d,
                                                  guint m,
                                                  guint y,
                                                  const gchar *mark);

KPLogStoreRecordType kp_log_store_get_iter_type  (KPLogStore *store,
                                                  GtkTreeIter *iter);


#endif /* KP_LOG_STORE_H_ */
