#include <stdio.h>

#include <glib.h>
#include <glib-object.h>

#include "kpcalendarentry.h"

static void       kp_calendar_entry_class_init        (GObjectClass * klass,
                                                       gpointer data);
static void       kp_calendar_entry_instance_init     (GObject * object,
                                                       gpointer data);
static void       kp_calendar_entry_instance_finalize (GObject * object);

GType
kp_calendar_entry_get_type (void)
{
  static GType kp_calendar_entry_type = 0;

  if (!kp_calendar_entry_type) {
    static const GTypeInfo kp_calendar_entry_info = {
      sizeof (KPCalendarEntryClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) kp_calendar_entry_class_init,
      (GClassFinalizeFunc) NULL,
      NULL,
      sizeof (KPCalendarEntry),
      0,
      (GInstanceInitFunc) kp_calendar_entry_instance_init,
      NULL
    };

    kp_calendar_entry_type = g_type_register_static (G_TYPE_OBJECT,
                                                  "KPCalendarEntry",
                                                  &kp_calendar_entry_info, 0);
  }
  return kp_calendar_entry_type;
}

static void
kp_calendar_entry_class_init (GObjectClass * klass,
                           gpointer data)
{
  GObjectClass *object_class;
  KPCalendarEntryClass *entry_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_calendar_entry_instance_finalize;
  
  entry_class = KP_CALENDAR_ENTRY_CLASS (klass);
  entry_class->get_human_name = NULL;
  entry_class->to_string = NULL;
  entry_class->to_xml = NULL;
  entry_class->parse = NULL;
}

static void
kp_calendar_entry_instance_init (GObject * object,
                              gpointer data)
{
  KP_CALENDAR_ENTRY (object)->datetime = kp_calendar_time_new ();
}

static void
kp_calendar_entry_instance_finalize (GObject * object)
{
  g_object_unref (KP_CALENDAR_ENTRY (object)->datetime);
}

KPCalendarEntry *
kp_calendar_entry_new ()
{
  return g_object_new (kp_calendar_entry_get_type (), NULL);
}


gchar *
kp_calendar_entry_to_string (KPCalendarEntry *entry)
{
  return KP_CALENDAR_ENTRY_GET_CLASS (entry)->to_string (entry);
}

xmlNodePtr 
kp_calendar_entry_to_xml (KPCalendarEntry *entry)
{
  return KP_CALENDAR_ENTRY_GET_CLASS (entry)->to_xml (entry);
}

KPCalendarTime *
kp_calendar_entry_get_date (KPCalendarEntry *entry)
{
  g_return_val_if_fail (KP_IS_CALENDAR_TIME (entry->datetime), NULL);
  return entry->datetime;
}


gboolean
kp_calendar_entry_parse (KPCalendarEntry *entry, xmlNodePtr node)
{
  return KP_CALENDAR_ENTRY_GET_CLASS (entry)->parse (entry, node);
}

gint
kp_calendar_entry_cmp (const KPCalendarEntry *entry, const KPCalendarEntry *entry2)
{
  GDate *date1;
  GDate *date2;

  date1 = kp_calendar_time_get_date (KP_CALENDAR_ENTRY (entry)->datetime);
  date2 = kp_calendar_time_get_date (KP_CALENDAR_ENTRY (entry2)->datetime);

  return g_date_compare (date1, date2);
}

gchar *
kp_calendar_entry_get_human_name (KPCalendarEntry *entry)
{
  return KP_CALENDAR_ENTRY_GET_CLASS (entry)->get_human_name (entry);
}
