#ifndef UTILS_H_
#define UTILS_H_

#include <glade/glade.h>

typedef struct KPDate_
{
  guint d;
  guint m;
  guint y;
} KPDate;

gboolean          kp_date_valid                  (KPDate *date);
void              kp_date_set_time               (KPDate *date, GTime time_);
KPDate           *kp_date_new_dmy                (guint d, guint m, guint y);
void              kp_date_free                   (KPDate *date);

gchar            *kp_date_seconds_to_string      (gdouble sec);
gchar            *kp_date_mseconds_to_std_string (guint32 msec);
gint32            kp_duration_str_to_ms          (const gchar *time_str);
gboolean          kp_is_valid_date_str           (const gchar *date_str);
gboolean          kp_is_valid_time_str           (const gchar *time_str);
gboolean          kp_is_valid_number             (const gchar *possible_number);
gdouble           kp_number                      (const gchar *);

gdouble           kp_is_valid_duration_entry_str (const gchar *time_str);

GValue           *kp_g_value_from_string         (const gchar *string);

gchar            *kp_g_value_to_string           (const GValue *value);

guint             kp_get_month_len               (guint m,
                                                  gboolean is_leap);

gboolean          kp_leap                        (guint year);

gboolean          kp_week_of_year                (guint *week, guint *year,
                                                  guint mm, guint dd);

glong             kp_calc_days                   (guint year, guint mm,
                                                  guint dd);
guint             kp_day_of_week                 (guint year,
                                                  guint mm,
                                                  guint dd);
glong             kp_dates_difference            (guint year1,
                                                  guint mm1,
                                                  guint dd1,
                                                  guint year2,
                                                  guint mm2,
                                                  guint dd2);

guint             kp_weeks_in_year               (guint year);

void              kp_print_debug_string          (const gchar *file,
                                                  const gchar *function,
                                                  guint line,
                                                  const gchar *message,
                                                  ...);
gint              kp_get_month_num                (const gchar *m);
gchar            *kp_get_month_name               (guint m);
guint             kp_month_num_by_year_day_number (guint day_num,
                                                   gboolean is_leap);

#define         KP_TAG_MATCH(node,tagname)  (xmlStrcasecmp(((xmlNodePtr)node)->name,tagname) == 0)


#ifdef G_HAVE_ISO_VARARGS
#define kp_debug(...) \
    (kp_print_debug_string (__FILE__, __PRETTY_FUNCTION__, __LINE__, __VA_ARGS__))
#elif defined (G_HAVE_GNUC_VARARGS)
#define kp_debug(message...) \
    (kp_print_debug_string (__FILE__, __PRETTY_FUNCTION__, __LINE__, message))
#else
static void
kp_debug (const gchar *message, ...)
{
  va_list args;
  va_start (args, message);
  kp_print_debug_string (message, args);
  va_end;
}
#endif /* G_HAVE_ISO_VARARGS */

#endif /* UTILS_H_*/
